/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.filerep;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.AbstractRepository;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.IRepositoryImporter;
import org.pentaho.di.repository.IRepositoryService;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryExporter;
import org.pentaho.di.repository.RepositoryImporter;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.repository.filerep.KettleFileRepositoryMeta;
import org.pentaho.di.repository.filerep.KettleFileRepositorySecurityProvider;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.stores.xml.XmlMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KettleFileRepository
extends AbstractRepository {
    private static final String EXT_TRANSFORMATION = ".ktr";
    private static final String EXT_JOB = ".kjb";
    private static final String EXT_DATABASE = ".kdb";
    private static final String EXT_SLAVE_SERVER = ".ksl";
    private static final String EXT_CLUSTER_SCHEMA = ".kcs";
    private static final String EXT_PARTITION_SCHEMA = ".kps";
    private static final String LOG_FILE = "repository.log";
    public static final String FILE_REPOSITORY_VERSION = "0.1";
    private KettleFileRepositoryMeta repositoryMeta;
    private KettleFileRepositorySecurityProvider securityProvider;
    private LogChannelInterface log;
    private boolean connected;
    private Map<Class<? extends IRepositoryService>, IRepositoryService> serviceMap;
    private List<Class<? extends IRepositoryService>> serviceList;
    public XmlMetaStore metaStore;

    @Override
    public void connect(String username, String password) throws KettleException {
        try {
            String metaStoreRootFolder = this.repositoryMeta.getBaseDirectory() + File.separator + ".meta";
            File metaStoreRootFolderFile = new File(this.repositoryMeta.getBaseDirectory() + File.separator + ".meta");
            this.metaStore = !metaStoreRootFolderFile.exists() ? (this.repositoryMeta.isReadOnly() ? null : (metaStoreRootFolderFile.mkdirs() ? new XmlMetaStore(metaStoreRootFolder) : null)) : new XmlMetaStore(metaStoreRootFolder);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        if (this.metaStore != null) {
            this.metaStore.setName(this.repositoryMeta.getName());
            this.metaStore.setDescription(this.repositoryMeta.getDescription());
        }
        this.connected = true;
    }

    @Override
    public void disconnect() {
        this.metaStore = null;
        this.connected = false;
    }

    @Override
    public void init(RepositoryMeta repositoryMeta) {
        this.serviceMap = new HashMap<Class<? extends IRepositoryService>, IRepositoryService>();
        this.serviceList = new ArrayList<Class<? extends IRepositoryService>>();
        this.repositoryMeta = (KettleFileRepositoryMeta)repositoryMeta;
        this.securityProvider = new KettleFileRepositorySecurityProvider(repositoryMeta);
        this.serviceMap.put(RepositorySecurityProvider.class, this.securityProvider);
        this.serviceList.add(RepositorySecurityProvider.class);
        this.metaStore = null;
        this.log = new LogChannel((Object)this);
    }

    @Override
    public LogChannelInterface getLog() {
        return this.log;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public RepositorySecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    @Override
    public RepositorySecurityManager getSecurityManager() {
        return null;
    }

    private String calcDirectoryName(RepositoryDirectoryInterface dir) {
        StringBuilder directory = new StringBuilder();
        String baseDir = this.repositoryMeta.getBaseDirectory();
        baseDir = Const.replace((String)baseDir, (String)"\\", (String)"/");
        directory.append(baseDir);
        if (!baseDir.endsWith("/")) {
            directory.append("/");
        }
        if (dir != null) {
            String path = this.calcRelativeElementDirectory(dir);
            if (path.startsWith("/")) {
                directory.append(path.substring(1));
            } else {
                directory.append(path);
            }
            if (!path.endsWith("/")) {
                directory.append("/");
            }
        }
        return directory.toString();
    }

    public String calcRelativeElementDirectory(RepositoryDirectoryInterface dir) {
        if (dir != null) {
            return dir.getPath();
        }
        return "/";
    }

    public String calcObjectId(RepositoryDirectoryInterface dir) {
        StringBuilder id = new StringBuilder();
        String path = this.calcRelativeElementDirectory(dir);
        id.append(path);
        if (!path.endsWith("/")) {
            id.append("/");
        }
        return id.toString();
    }

    public String calcObjectId(RepositoryDirectoryInterface directory, String name, String extension) {
        StringBuilder id = new StringBuilder();
        String path = this.calcRelativeElementDirectory(directory);
        id.append(path);
        if (!path.endsWith("/")) {
            id.append("/");
        }
        if (name.startsWith("/")) {
            id.append(name.substring(1)).append(extension);
        } else {
            id.append(name).append(extension);
        }
        return id.toString();
    }

    public String calcObjectId(RepositoryElementInterface element) {
        RepositoryDirectoryInterface directory = element.getRepositoryDirectory();
        String name = element.getName();
        String extension = element.getRepositoryElementType().getExtension();
        return this.calcObjectId(directory, name, extension);
    }

    private String calcFilename(RepositoryElementInterface element) {
        return this.calcFilename(element.getRepositoryDirectory(), element.getName(), element.getRepositoryElementType().getExtension());
    }

    private String calcFilename(RepositoryDirectoryInterface dir, String name, String extension) {
        StringBuilder filename = new StringBuilder();
        filename.append(this.calcDirectoryName(dir));
        String objectName = name + extension;
        filename.append(objectName);
        return filename.toString();
    }

    public String calcFilename(ObjectId id) {
        return this.calcDirectoryName(null) + id.toString();
    }

    FileObject getFileObject(RepositoryElementInterface element) throws KettleFileException {
        return KettleVFS.getFileObject((String)this.calcFilename(element.getRepositoryDirectory(), element.getName(), element.getRepositoryElementType().getExtension()));
    }

    @Override
    public boolean exists(String name, RepositoryDirectoryInterface repositoryDirectory, RepositoryObjectType objectType) throws KettleException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)this.calcFilename(repositoryDirectory, name, objectType.getExtension()));
            return fileObject.exists();
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void save(RepositoryElementInterface repositoryElement, String versionComment) throws KettleException {
        this.save(repositoryElement, versionComment, null);
    }

    @Override
    public void save(RepositoryElementInterface repositoryElement, String versionComment, ProgressMonitorListener monitor, boolean overwrite) throws KettleException {
        this.save(repositoryElement, versionComment, monitor, null, overwrite);
    }

    @Override
    public void save(RepositoryElementInterface repositoryElement, String versionComment, Calendar versionDate, ProgressMonitorListener monitor, boolean overwrite) throws KettleException {
        this.save(repositoryElement, versionComment, monitor, null, overwrite);
    }

    public void save(RepositoryElementInterface repositoryElement, String versionComment, ProgressMonitorListener monitor, ObjectId parentId, boolean used) throws KettleException {
        try {
            if (!(repositoryElement instanceof XMLInterface) && !(repositoryElement instanceof SharedObjectInterface)) {
                throw new KettleException("Class [" + repositoryElement.getClass().getName() + "] needs to implement the XML Interface in order to save it to disk");
            }
            if (!Const.isEmpty((String)versionComment)) {
                this.insertLogEntry("Save repository element : " + repositoryElement.toString() + " : " + versionComment);
            }
            StringObjectId objectId = new StringObjectId(this.calcObjectId(repositoryElement));
            FileObject fileObject = this.getFileObject(repositoryElement);
            String xml = ((XMLInterface)repositoryElement).getXML();
            OutputStream os = KettleVFS.getOutputStream((FileObject)fileObject, (boolean)false);
            os.write(xml.getBytes("UTF-8"));
            os.close();
            if (repositoryElement instanceof ChangedFlagInterface) {
                ((ChangedFlagInterface)repositoryElement).clearChanged();
            }
            if (repositoryElement.getObjectId() != null && !repositoryElement.getObjectId().equals(objectId)) {
                this.delObject(repositoryElement.getObjectId());
            }
            repositoryElement.setObjectId((ObjectId)objectId);
            if (repositoryElement instanceof TransMeta) {
                ((TransMeta)repositoryElement).saveMetaStoreObjects(this, (IMetaStore)this.metaStore);
            }
            if (repositoryElement instanceof JobMeta) {
                ((JobMeta)repositoryElement).saveMetaStoreObjects(this, (IMetaStore)this.metaStore);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save repository element [" + repositoryElement + "] to XML file : " + this.calcFilename(repositoryElement), (Throwable)e);
        }
    }

    @Override
    public RepositoryDirectoryInterface createRepositoryDirectory(RepositoryDirectoryInterface parentDirectory, String directoryPath) throws KettleException {
        String folder;
        String newFolder = folder = this.calcDirectoryName(parentDirectory);
        newFolder = folder.endsWith("/") ? newFolder + directoryPath : newFolder + "/" + directoryPath;
        FileObject parent = KettleVFS.getFileObject((String)newFolder);
        try {
            parent.createFolder();
        }
        catch (FileSystemException e) {
            throw new KettleException("Unable to create folder " + newFolder, (Throwable)e);
        }
        RepositoryDirectory newDir = new RepositoryDirectory(parentDirectory, directoryPath);
        parentDirectory.addSubdirectory((RepositoryDirectoryInterface)newDir);
        newDir.setObjectId((ObjectId)new StringObjectId(this.calcObjectId((RepositoryDirectoryInterface)newDir)));
        return newDir;
    }

    @Override
    public void saveRepositoryDirectory(RepositoryDirectoryInterface dir) throws KettleException {
        try {
            String filename = this.calcDirectoryName(dir);
            StringObjectId objectId = new StringObjectId(this.calcRelativeElementDirectory(dir));
            FileObject fileObject = KettleVFS.getFileObject((String)filename);
            fileObject.createFolder();
            dir.setObjectId((ObjectId)objectId);
            this.log.logDetailed("New id of directory = " + dir.getObjectId());
        }
        catch (Exception e) {
            throw new KettleException("Unable to save directory [" + dir + "] in the repository", (Throwable)e);
        }
    }

    private void delObject(ObjectId id) throws KettleException {
        String filename = this.calcFilename(id);
        this.deleteFile(filename);
    }

    @Override
    public void deleteJob(ObjectId id_job) throws KettleException {
        this.delObject(id_job);
    }

    @Override
    public void deleteTransformation(ObjectId id_transformation) throws KettleException {
        this.delObject(id_transformation);
    }

    @Override
    public void deleteClusterSchema(ObjectId id_cluster) throws KettleException {
        this.deleteFile(id_cluster.getId());
    }

    public void deleteCondition(ObjectId id_condition) throws KettleException {
    }

    @Override
    public void deletePartitionSchema(ObjectId id_partition_schema) throws KettleException {
        this.deleteFile(id_partition_schema.getId());
    }

    @Override
    public void deleteRepositoryDirectory(RepositoryDirectoryInterface dir) throws KettleException {
    }

    @Override
    public void deleteSlave(ObjectId id_slave) throws KettleException {
        this.deleteFile(this.calcDirectoryName(null) + id_slave.getId());
    }

    @Override
    public void deleteDatabaseMeta(String databaseName) throws KettleException {
        this.deleteRootObject(databaseName, EXT_DATABASE);
    }

    public void deleteRootObject(String name, String extension) throws KettleException {
        try {
            String filename = this.calcDirectoryName(null) + name + extension;
            FileObject fileObject = KettleVFS.getFileObject((String)filename);
            fileObject.delete();
        }
        catch (Exception e) {
            throw new KettleException("Unable to delete database with name [" + name + "] and extension [" + extension + "]", (Throwable)e);
        }
    }

    public void deleteFile(String filename) throws KettleException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)filename);
            fileObject.delete();
        }
        catch (Exception e) {
            throw new KettleException("Unable to delete file with name [" + filename + "]", (Throwable)e);
        }
    }

    @Override
    public ObjectId getClusterID(String name) throws KettleException {
        return new StringObjectId(this.calcObjectId((RepositoryDirectoryInterface)((RepositoryDirectory)null)) + name + EXT_SLAVE_SERVER);
    }

    @Override
    public ObjectId[] getClusterIDs(boolean includeDeleted) throws KettleException {
        return this.getRootObjectIDs(EXT_CLUSTER_SCHEMA);
    }

    @Override
    public String[] getClusterNames(boolean includeDeleted) throws KettleException {
        return this.convertRootIDsToNames(this.getClusterIDs(false));
    }

    private String[] convertRootIDsToNames(ObjectId[] ids) {
        String[] names = new String[ids.length];
        for (int i = 0; i < names.length; ++i) {
            String id = ids[i].getId();
            names[i] = id.substring(0, id.length() - 4);
        }
        return names;
    }

    public String[] getClustersUsingSlave(ObjectId id_slave) throws KettleException {
        return new String[0];
    }

    public ObjectId[] getTransformationConditionIDs(ObjectId id_transformation) throws KettleException {
        return new ObjectId[0];
    }

    public ObjectId[] getDatabaseAttributeIDs(ObjectId id_database) throws KettleException {
        return new ObjectId[0];
    }

    private ObjectId getObjectId(RepositoryDirectoryInterface repositoryDirectory, String name, String extension) throws KettleException {
        try {
            String filename = this.calcFilename(repositoryDirectory, name, extension);
            if (!KettleVFS.getFileObject((String)filename).exists()) {
                return null;
            }
            return new StringObjectId(this.calcObjectId(repositoryDirectory, name, extension));
        }
        catch (Exception e) {
            throw new KettleException("Error finding ID for directory [" + repositoryDirectory + "] and name [" + name + "]", (Throwable)e);
        }
    }

    @Override
    public ObjectId getDatabaseID(String name) throws KettleException {
        ObjectId[] existingIds;
        String[] existingNames;
        int index;
        ObjectId match = this.getObjectId(null, name, EXT_DATABASE);
        if (match == null && (index = DatabaseMeta.indexOfName((String[])(existingNames = this.getDatabaseNames(existingIds = this.getDatabaseIDs(false))), (String)name)) != -1) {
            return this.getObjectId(null, existingNames[index], EXT_DATABASE);
        }
        return match;
    }

    public ObjectId[] getTransformationDatabaseIDs(ObjectId id_transformation) throws KettleException {
        return new ObjectId[0];
    }

    @Override
    public ObjectId[] getDatabaseIDs(boolean includeDeleted) throws KettleException {
        return this.getRootObjectIDs(EXT_DATABASE);
    }

    @Override
    public String[] getDatabaseNames(boolean includeDeleted) throws KettleException {
        return this.convertRootIDsToNames(this.getDatabaseIDs(false));
    }

    private String[] getDatabaseNames(ObjectId[] databaseIds) throws KettleException {
        return this.convertRootIDsToNames(databaseIds);
    }

    @Override
    public String[] getDirectoryNames(ObjectId id_directory) throws KettleException {
        RepositoryDirectoryInterface tree = this.loadRepositoryDirectoryTree();
        RepositoryDirectoryInterface directory = tree.findDirectory(id_directory);
        String[] names = new String[directory.getNrSubdirectories()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = directory.getSubdirectory(i).getName();
        }
        return names;
    }

    @Override
    public ObjectId getJobId(String name, RepositoryDirectoryInterface repositoryDirectory) throws KettleException {
        return this.getObjectId(repositoryDirectory, name, EXT_JOB);
    }

    @Override
    public String[] getJobNames(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        try {
            ArrayList<String> list = new ArrayList<String>();
            RepositoryDirectoryInterface tree = this.loadRepositoryDirectoryTree();
            RepositoryDirectoryInterface directory = tree.findDirectory(id_directory);
            String folderName = this.calcDirectoryName(directory);
            FileObject folder = KettleVFS.getFileObject((String)folderName);
            for (FileObject child : folder.getChildren()) {
                String name;
                if (!child.getType().equals((Object)FileType.FILE) || child.isHidden() && this.repositoryMeta.isHidingHiddenFiles() || !(name = child.getName().getBaseName()).endsWith(EXT_JOB)) continue;
                String jobName = name.substring(0, name.length() - 4);
                list.add(jobName);
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get list of transformations names in folder with id : " + id_directory, (Throwable)e);
        }
    }

    public ObjectId[] getJobNoteIDs(ObjectId id_job) throws KettleException {
        return new ObjectId[0];
    }

    @Override
    public String[] getJobsUsingDatabase(ObjectId id_database) throws KettleException {
        return new String[0];
    }

    @Override
    public String getName() {
        return this.repositoryMeta.getName();
    }

    @Override
    public ObjectId getPartitionSchemaID(String name) throws KettleException {
        return new StringObjectId(this.calcObjectId((RepositoryDirectoryInterface)((RepositoryDirectory)null)) + name + EXT_SLAVE_SERVER);
    }

    @Override
    public ObjectId[] getPartitionSchemaIDs(boolean includeDeleted) throws KettleException {
        return this.getRootObjectIDs(EXT_PARTITION_SCHEMA);
    }

    @Override
    public String[] getPartitionSchemaNames(boolean includeDeleted) throws KettleException {
        return this.convertRootIDsToNames(this.getPartitionSchemaIDs(false));
    }

    public ObjectId getRootDirectoryID() throws KettleException {
        return null;
    }

    @Override
    public ObjectId getSlaveID(String name) throws KettleException {
        ObjectId[] ids;
        String slaveID = name + EXT_SLAVE_SERVER;
        for (ObjectId rootID : ids = this.getRootObjectIDs(EXT_SLAVE_SERVER)) {
            if (!rootID.toString().equals(slaveID)) continue;
            return new StringObjectId(slaveID.toString());
        }
        return null;
    }

    private ObjectId[] getRootObjectIDs(String extension) throws KettleException {
        try {
            ArrayList<StringObjectId> list = new ArrayList<StringObjectId>();
            String folderName = this.repositoryMeta.getBaseDirectory();
            FileObject folder = KettleVFS.getFileObject((String)folderName);
            for (FileObject child : folder.getChildren()) {
                String name;
                if (!child.getType().equals((Object)FileType.FILE) || child.isHidden() && this.repositoryMeta.isHidingHiddenFiles() || !(name = child.getName().getBaseName()).endsWith(extension)) continue;
                list.add(new StringObjectId(name));
            }
            return list.toArray(new ObjectId[list.size()]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get root object ids for extension [" + extension + "]", (Throwable)e);
        }
    }

    @Override
    public ObjectId[] getSlaveIDs(boolean includeDeleted) throws KettleException {
        return this.getRootObjectIDs(EXT_SLAVE_SERVER);
    }

    public ObjectId[] getClusterSlaveIDs(ObjectId id_cluster_schema) throws KettleException {
        return new ObjectId[0];
    }

    @Override
    public String[] getSlaveNames(boolean includeDeleted) throws KettleException {
        return this.convertRootIDsToNames(this.getSlaveIDs(false));
    }

    @Override
    public List<SlaveServer> getSlaveServers() throws KettleException {
        ArrayList<SlaveServer> list = new ArrayList<SlaveServer>();
        for (ObjectId id : this.getSlaveIDs(false)) {
            list.add(this.loadSlaveServer(id, null));
        }
        return list;
    }

    @Override
    public boolean getStepAttributeBoolean(ObjectId id_step, int nr, String code, boolean def) throws KettleException {
        return false;
    }

    @Override
    public long getStepAttributeInteger(ObjectId id_step, int nr, String code) throws KettleException {
        return 0L;
    }

    @Override
    public String getStepAttributeString(ObjectId id_step, int nr, String code) throws KettleException {
        return null;
    }

    @Override
    public long getJobEntryAttributeInteger(ObjectId id_jobentry, int nr, String code) throws KettleException {
        return 0L;
    }

    @Override
    public String getJobEntryAttributeString(ObjectId id_jobentry, int nr, String code) throws KettleException {
        return null;
    }

    @Override
    public boolean getJobEntryAttributeBoolean(ObjectId id_jobentry, int nr, String code, boolean def) throws KettleException {
        return false;
    }

    public ObjectId[] getSubConditionIDs(ObjectId id_condition) throws KettleException {
        return null;
    }

    public ObjectId[] getSubDirectoryIDs(ObjectId id_directory) throws KettleException {
        RepositoryDirectoryInterface tree = this.loadRepositoryDirectoryTree();
        RepositoryDirectoryInterface directory = tree.findDirectory(id_directory);
        ObjectId[] objectIds = new ObjectId[directory.getNrSubdirectories()];
        for (int i = 0; i < objectIds.length; ++i) {
            objectIds[i] = directory.getSubdirectory(i).getObjectId();
        }
        return objectIds;
    }

    public ObjectId[] getTransNoteIDs(ObjectId id_transformation) throws KettleException {
        return new ObjectId[0];
    }

    public ObjectId[] getTransformationClusterSchemaIDs(ObjectId id_transformation) throws KettleException {
        return new ObjectId[0];
    }

    @Override
    public ObjectId getTransformationID(String name, RepositoryDirectoryInterface repositoryDirectory) throws KettleException {
        return this.getObjectId(repositoryDirectory, name, EXT_TRANSFORMATION);
    }

    @Override
    public String[] getTransformationNames(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        try {
            ArrayList<String> list = new ArrayList<String>();
            RepositoryDirectoryInterface tree = this.loadRepositoryDirectoryTree();
            RepositoryDirectoryInterface directory = tree.findDirectory(id_directory);
            String folderName = this.calcDirectoryName(directory);
            FileObject folder = KettleVFS.getFileObject((String)folderName);
            for (FileObject child : folder.getChildren()) {
                String name;
                if (!child.getType().equals((Object)FileType.FILE) || child.isHidden() && this.repositoryMeta.isHidingHiddenFiles() || !(name = child.getName().getBaseName()).endsWith(EXT_TRANSFORMATION)) continue;
                String transName = name.substring(0, name.length() - 4);
                list.add(transName);
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get list of transformations names in folder with id : " + id_directory, (Throwable)e);
        }
    }

    public ObjectId[] getTransformationPartitionSchemaIDs(ObjectId id_transformation) throws KettleException {
        return new ObjectId[0];
    }

    public String[] getTransformationsUsingCluster(ObjectId id_cluster) throws KettleException {
        return new String[0];
    }

    @Override
    public String[] getTransformationsUsingDatabase(ObjectId id_database) throws KettleException {
        return new String[0];
    }

    public String[] getTransformationsUsingPartitionSchema(ObjectId id_partition_schema) throws KettleException {
        return new String[0];
    }

    public String[] getTransformationsUsingSlave(ObjectId id_slave) throws KettleException {
        return new String[0];
    }

    @Override
    public String getVersion() {
        return FILE_REPOSITORY_VERSION;
    }

    public ObjectId insertClusterSlave(ClusterSchema clusterSchema, SlaveServer slaveServer) throws KettleException {
        return null;
    }

    @Override
    public void insertJobEntryDatabase(ObjectId id_job, ObjectId id_jobentry, ObjectId id_database) throws KettleException {
    }

    public void insertJobNote(ObjectId id_job, ObjectId id_note) throws KettleException {
    }

    @Override
    public ObjectId insertLogEntry(String description) throws KettleException {
        String logfile = this.calcDirectoryName(null) + LOG_FILE;
        try {
            OutputStream outputStream = KettleVFS.getOutputStream((String)logfile, (boolean)true);
            outputStream.write(description.getBytes());
            outputStream.write(Const.CR.getBytes());
            outputStream.close();
            return new StringObjectId(logfile);
        }
        catch (IOException e) {
            throw new KettleException("Unable to write log entry to file [" + logfile + "]");
        }
    }

    @Override
    public void insertStepDatabase(ObjectId id_transformation, ObjectId id_step, ObjectId id_database) throws KettleException {
    }

    public void insertTransNote(ObjectId id_transformation, ObjectId id_note) throws KettleException {
    }

    public void insertTransStepCondition(ObjectId id_transformation, ObjectId id_step, ObjectId id_condition) throws KettleException {
    }

    public ObjectId insertTransformationCluster(ObjectId id_transformation, ObjectId id_cluster) throws KettleException {
        return null;
    }

    public ObjectId insertTransformationPartitionSchema(ObjectId id_transformation, ObjectId id_partition_schema) throws KettleException {
        return null;
    }

    public ObjectId insertTransformationSlave(ObjectId id_transformation, ObjectId id_slave) throws KettleException {
        return null;
    }

    @Override
    public ClusterSchema loadClusterSchema(ObjectId id_cluster_schema, List<SlaveServer> slaveServers, String versionName) throws KettleException {
        try {
            return new ClusterSchema(this.loadNodeFromXML(id_cluster_schema, "clusterschema"), slaveServers);
        }
        catch (Exception e) {
            throw new KettleException("Unable to load cluster schema from the file repository", (Throwable)e);
        }
    }

    public Condition loadCondition(ObjectId id_condition) throws KettleException {
        return null;
    }

    @Override
    public Condition loadConditionFromStepAttribute(ObjectId id_step, String code) throws KettleException {
        return null;
    }

    public Node loadNodeFromXML(ObjectId id, String tag) throws KettleException {
        try {
            String filename = this.calcDirectoryName(null) + id.getId();
            FileObject fileObject = KettleVFS.getFileObject((String)filename);
            Document document = XMLHandler.loadXMLFile((FileObject)fileObject);
            Node node = XMLHandler.getSubNode((Node)document, (String)tag);
            return node;
        }
        catch (Exception e) {
            throw new KettleException("Unable to load XML object from object with ID [" + id + "] and tag [" + tag + "]", (Throwable)e);
        }
    }

    @Override
    public DatabaseMeta loadDatabaseMeta(ObjectId id_database, String versionName) throws KettleException {
        try {
            return new DatabaseMeta(this.loadNodeFromXML(id_database, "connection"));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load database connection from the file repository", (Throwable)e);
        }
    }

    @Override
    public DatabaseMeta loadDatabaseMetaFromJobEntryAttribute(ObjectId id_jobentry, String nameCode, int nr, String idCode, List<DatabaseMeta> databases) throws KettleException {
        return null;
    }

    @Override
    public void saveDatabaseMetaJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String nameCode, String idCode, DatabaseMeta database) throws KettleException {
    }

    @Override
    public DatabaseMeta loadDatabaseMetaFromStepAttribute(ObjectId id_step, String code, List<DatabaseMeta> databases) throws KettleException {
        return null;
    }

    @Override
    public JobMeta loadJob(String jobname, RepositoryDirectoryInterface repdir, ProgressMonitorListener monitor, String versionName) throws KettleException {
        String filename = this.calcDirectoryName(repdir) + jobname + EXT_JOB;
        JobMeta jobMeta = new JobMeta(filename, this);
        jobMeta.setFilename(null);
        jobMeta.setName(jobname);
        jobMeta.setObjectId((ObjectId)new StringObjectId(this.calcObjectId(repdir, jobname, EXT_JOB)));
        this.readDatabases(jobMeta, true);
        jobMeta.clearChanged();
        return jobMeta;
    }

    @Override
    public PartitionSchema loadPartitionSchema(ObjectId id_partition_schema, String versionName) throws KettleException {
        try {
            return new PartitionSchema(this.loadNodeFromXML(id_partition_schema, "partitionschema"));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load partition schema from the file repository", (Throwable)e);
        }
    }

    @Override
    public RepositoryDirectoryInterface loadRepositoryDirectoryTree() throws KettleException {
        RepositoryDirectory root = new RepositoryDirectory();
        root.setObjectId((ObjectId)new StringObjectId("/"));
        return this.loadRepositoryDirectoryTree((RepositoryDirectoryInterface)root);
    }

    public RepositoryDirectoryInterface loadRepositoryDirectoryTree(RepositoryDirectoryInterface dir) throws KettleException {
        try {
            String folderName = this.calcDirectoryName(dir);
            FileObject folder = KettleVFS.getFileObject((String)folderName);
            for (FileObject child : folder.getChildren()) {
                if (!child.getType().equals((Object)FileType.FOLDER) || child.isHidden() && this.repositoryMeta.isHidingHiddenFiles() || ".meta".equals(child.getName().getBaseName())) continue;
                RepositoryDirectory subDir = new RepositoryDirectory(dir, child.getName().getBaseName());
                subDir.setObjectId((ObjectId)new StringObjectId(this.calcObjectId((RepositoryDirectoryInterface)subDir)));
                dir.addSubdirectory((RepositoryDirectoryInterface)subDir);
                this.loadRepositoryDirectoryTree((RepositoryDirectoryInterface)subDir);
            }
            return dir;
        }
        catch (Exception e) {
            throw new KettleException("Unable to load the directory tree from this file repository", (Throwable)e);
        }
    }

    @Override
    public RepositoryDirectoryInterface findDirectory(String directory) throws KettleException {
        return this.loadRepositoryDirectoryTree().findDirectory(directory);
    }

    @Override
    public RepositoryDirectoryInterface findDirectory(ObjectId directory) throws KettleException {
        return this.loadRepositoryDirectoryTree().findDirectory(directory);
    }

    @Override
    public List<RepositoryElementMetaInterface> getTransformationObjects(ObjectId idDirectory, boolean includeDeleted) throws KettleException {
        try {
            ArrayList<RepositoryElementMetaInterface> list = new ArrayList<RepositoryElementMetaInterface>();
            RepositoryDirectoryInterface tree = this.loadRepositoryDirectoryTree();
            RepositoryDirectoryInterface directory = tree.findDirectory(idDirectory);
            String folderName = this.calcDirectoryName(directory);
            FileObject folder = KettleVFS.getFileObject((String)folderName);
            for (FileObject child : folder.getChildren()) {
                String name;
                if (!child.getType().equals((Object)FileType.FILE) || child.isHidden() && this.repositoryMeta.isHidingHiddenFiles() || !(name = child.getName().getBaseName()).endsWith(EXT_TRANSFORMATION)) continue;
                String transName = name.substring(0, name.length() - 4);
                StringObjectId id = new StringObjectId(this.calcObjectId(directory, transName, EXT_TRANSFORMATION));
                Date date = new Date(child.getContent().getLastModifiedTime());
                list.add(new RepositoryObject((ObjectId)id, transName, directory, "-", date, RepositoryObjectType.TRANSFORMATION, "", false));
            }
            return list;
        }
        catch (Exception e) {
            throw new KettleException("Unable to get list of transformations in folder with id : " + idDirectory, (Throwable)e);
        }
    }

    @Override
    public List<RepositoryElementMetaInterface> getJobObjects(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        try {
            ArrayList<RepositoryElementMetaInterface> list = new ArrayList<RepositoryElementMetaInterface>();
            RepositoryDirectoryInterface tree = this.loadRepositoryDirectoryTree();
            RepositoryDirectoryInterface directory = tree.findDirectory(id_directory);
            String folderName = this.calcDirectoryName(directory);
            FileObject folder = KettleVFS.getFileObject((String)folderName);
            for (FileObject child : folder.getChildren()) {
                String name;
                if (!child.getType().equals((Object)FileType.FILE) || child.isHidden() && this.repositoryMeta.isHidingHiddenFiles() || !(name = child.getName().getBaseName()).endsWith(EXT_JOB)) continue;
                String jobName = name.substring(0, name.length() - 4);
                StringObjectId id = new StringObjectId(this.calcObjectId(directory, jobName, EXT_JOB));
                Date date = new Date(child.getContent().getLastModifiedTime());
                list.add(new RepositoryObject((ObjectId)id, jobName, directory, "-", date, RepositoryObjectType.JOB, "", false));
            }
            return list;
        }
        catch (Exception e) {
            throw new KettleException("Unable to get list of jobs in folder with id : " + id_directory, (Throwable)e);
        }
    }

    public int getNrSubDirectories(ObjectId id_directory) throws KettleException {
        return 0;
    }

    @Override
    public SlaveServer loadSlaveServer(ObjectId id_slave_server, String versionName) throws KettleException {
        try {
            return new SlaveServer(this.loadNodeFromXML(id_slave_server, "slaveserver"));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load slave server from the file repository", (Throwable)e);
        }
    }

    @Override
    public TransMeta loadTransformation(String transname, RepositoryDirectoryInterface repdir, ProgressMonitorListener monitor, boolean setInternalVariables, String versionName) throws KettleException {
        String filename = this.calcDirectoryName(repdir) + transname + EXT_TRANSFORMATION;
        TransMeta transMeta = new TransMeta(filename, this, setInternalVariables);
        transMeta.setRepository(this);
        transMeta.setMetaStore((IMetaStore)this.getMetaStore());
        transMeta.setFilename(null);
        transMeta.setName(transname);
        transMeta.setObjectId((ObjectId)new StringObjectId(this.calcObjectId(repdir, transname, EXT_TRANSFORMATION)));
        this.readDatabases(transMeta, true);
        transMeta.clearChanged();
        return transMeta;
    }

    public void readDatabases(HasDatabasesInterface transMeta, boolean overWriteShared) throws KettleException {
        ObjectId[] dbids = this.getDatabaseIDs(false);
        for (int i = 0; i < dbids.length; ++i) {
            DatabaseMeta check;
            DatabaseMeta databaseMeta = this.loadDatabaseMeta(dbids[i], null);
            if (transMeta instanceof VariableSpace) {
                databaseMeta.shareVariablesWith((VariableSpace)transMeta);
            }
            if ((check = transMeta.findDatabase(databaseMeta.getName())) != null && !overWriteShared || databaseMeta.getName() == null) continue;
            transMeta.addOrReplaceDatabase(databaseMeta);
            if (overWriteShared) continue;
            databaseMeta.setChanged(false);
        }
    }

    public ValueMetaAndData loadValueMetaAndData(ObjectId id_value) throws KettleException {
        return null;
    }

    public void moveJob(String jobname, ObjectId id_directory_from, ObjectId id_directory_to) throws KettleException {
    }

    public void moveTransformation(String transname, ObjectId id_directory_from, ObjectId id_directory_to) throws KettleException {
    }

    @Override
    public List<DatabaseMeta> readDatabases() throws KettleException {
        ArrayList<DatabaseMeta> list = new ArrayList<DatabaseMeta>();
        for (ObjectId id : this.getDatabaseIDs(false)) {
            list.add(this.loadDatabaseMeta(id, null));
        }
        return list;
    }

    @Override
    public void clearSharedObjectCache() {
    }

    @Override
    public SharedObjects readJobMetaSharedObjects(JobMeta jobMeta) throws KettleException {
        SharedObjects sharedObjects = jobMeta.readSharedObjects();
        for (ObjectId id : this.getDatabaseIDs(false)) {
            DatabaseMeta databaseMeta = this.loadDatabaseMeta(id, null);
            databaseMeta.shareVariablesWith((VariableSpace)jobMeta);
            jobMeta.addOrReplaceDatabase(databaseMeta);
        }
        for (ObjectId id : this.getSlaveIDs(false)) {
            SlaveServer slaveServer = this.loadSlaveServer(id, null);
            slaveServer.shareVariablesWith(jobMeta);
            jobMeta.addOrReplaceSlaveServer(slaveServer);
        }
        return sharedObjects;
    }

    @Override
    public SharedObjects readTransSharedObjects(TransMeta transMeta) throws KettleException {
        SharedObjects sharedObjects = transMeta.readSharedObjects();
        for (ObjectId id : this.getDatabaseIDs(false)) {
            DatabaseMeta databaseMeta = this.loadDatabaseMeta(id, null);
            databaseMeta.shareVariablesWith((VariableSpace)transMeta);
            transMeta.addOrReplaceDatabase(databaseMeta);
        }
        for (ObjectId id : this.getSlaveIDs(false)) {
            SlaveServer slaveServer = this.loadSlaveServer(id, null);
            slaveServer.shareVariablesWith(transMeta);
            transMeta.addOrReplaceSlaveServer(slaveServer);
        }
        for (ObjectId id : this.getClusterIDs(false)) {
            ClusterSchema clusterSchema = this.loadClusterSchema(id, transMeta.getSlaveServers(), null);
            clusterSchema.shareVariablesWith(transMeta);
            transMeta.addOrReplaceClusterSchema(clusterSchema);
        }
        for (ObjectId id : this.getPartitionSchemaIDs(false)) {
            PartitionSchema partitionSchema = this.loadPartitionSchema(id, null);
            transMeta.addOrReplacePartitionSchema(partitionSchema);
        }
        return sharedObjects;
    }

    private ObjectId renameObject(ObjectId id, RepositoryDirectoryInterface newDirectory, String newName, String extension) throws KettleException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)(this.calcDirectoryName(null) + id.getId()));
            if (Const.isEmpty((String)newName)) {
                newName = this.calcObjectName(id);
            }
            String newFilename = this.calcDirectoryName(newDirectory) + newName + extension;
            FileObject newObject = KettleVFS.getFileObject((String)newFilename);
            fileObject.moveTo(newObject);
            return new StringObjectId(this.calcObjectId(newDirectory, newName, extension));
        }
        catch (Exception e) {
            throw new KettleException("Unable to rename object with ID [" + id + "] to [" + newName + "]", (Throwable)e);
        }
    }

    private String calcObjectName(ObjectId id) {
        int slashIndex = id.getId().lastIndexOf(47);
        int dotIndex = id.getId().lastIndexOf(46);
        return id.getId().substring(slashIndex + 1, dotIndex);
    }

    @Override
    public ObjectId renameJob(ObjectId id_job, RepositoryDirectoryInterface newDir, String newName) throws KettleException {
        return this.renameJob(id_job, null, newDir, newName);
    }

    @Override
    public ObjectId renameJob(ObjectId id_job, String versionComment, RepositoryDirectoryInterface newDir, String newName) throws KettleException {
        ObjectId objectId = this.renameObject(id_job, newDir, newName, EXT_JOB);
        if (!Const.isEmpty((String)versionComment)) {
            this.insertLogEntry("Rename job : " + versionComment);
        }
        return objectId;
    }

    @Override
    public ObjectId renameRepositoryDirectory(ObjectId id, RepositoryDirectoryInterface newParentDir, String newName) throws KettleException {
        if (newParentDir != null || newName != null) {
            try {
                RepositoryDirectoryInterface tree = this.loadRepositoryDirectoryTree();
                RepositoryDirectoryInterface dir = tree.findDirectory(id);
                if (dir == null) {
                    throw new KettleException("Could not find folder [" + id + "]");
                }
                newName = newName != null ? newName : dir.getName();
                FileObject folder = KettleVFS.getFileObject((String)dir.getPath());
                String newFolderName = null;
                if (newParentDir != null) {
                    FileObject newParentFolder = KettleVFS.getFileObject((String)newParentDir.getPath());
                    newFolderName = newParentFolder.toString() + "/" + newName;
                } else {
                    newFolderName = folder.getParent().toString() + "/" + newName;
                }
                FileObject newFolder = KettleVFS.getFileObject((String)newFolderName);
                folder.moveTo(newFolder);
                return new StringObjectId(dir.getObjectId());
            }
            catch (Exception e) {
                throw new KettleException("Unable to rename directory folder to [" + id + "]");
            }
        }
        return id;
    }

    @Override
    public ObjectId renameTransformation(ObjectId id_transformation, RepositoryDirectoryInterface newDir, String newName) throws KettleException {
        return this.renameTransformation(id_transformation, null, newDir, newName);
    }

    @Override
    public ObjectId renameTransformation(ObjectId id_transformation, String versionComment, RepositoryDirectoryInterface newDir, String newName) throws KettleException {
        ObjectId objectId = this.renameObject(id_transformation, newDir, newName, EXT_TRANSFORMATION);
        if (!Const.isEmpty((String)versionComment)) {
            this.insertLogEntry("Rename transformation : " + versionComment);
        }
        return objectId;
    }

    public ObjectId saveCondition(Condition condition) throws KettleException {
        return null;
    }

    public ObjectId saveCondition(Condition condition, ObjectId id_condition_parent) throws KettleException {
        return null;
    }

    @Override
    public void saveConditionStepAttribute(ObjectId id_transformation, ObjectId id_step, String code, Condition condition) throws KettleException {
    }

    public void saveDatabaseMetaJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, String code, DatabaseMeta database) throws KettleException {
    }

    @Override
    public void saveDatabaseMetaStepAttribute(ObjectId id_transformation, ObjectId id_step, String code, DatabaseMeta database) throws KettleException {
    }

    @Override
    public void saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String code, String value) throws KettleException {
    }

    @Override
    public void saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String code, boolean value) throws KettleException {
    }

    @Override
    public void saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String code, long value) throws KettleException {
    }

    @Override
    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, String value) throws KettleException {
    }

    @Override
    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, boolean value) throws KettleException {
    }

    @Override
    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, long value) throws KettleException {
    }

    @Override
    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, double value) throws KettleException {
    }

    public void delUser(ObjectId id_user) throws KettleException {
    }

    public ObjectId getUserID(String login) throws KettleException {
        return null;
    }

    public ObjectId[] getUserIDs() throws KettleException {
        return new ObjectId[0];
    }

    @Override
    public IUser getUserInfo() {
        return null;
    }

    public String[] getUserLogins() throws KettleException {
        return new String[0];
    }

    public UserInfo loadUserInfo(String login) throws KettleException {
        return null;
    }

    public UserInfo loadUserInfo(String login, String password) throws KettleException {
        return null;
    }

    public void renameUser(ObjectId id_user, String newname) throws KettleException {
    }

    public void saveUserInfo(UserInfo userInfo) throws KettleException {
    }

    @Override
    public int countNrJobEntryAttributes(ObjectId id_jobentry, String code) throws KettleException {
        return 0;
    }

    @Override
    public int countNrStepAttributes(ObjectId id_step, String code) throws KettleException {
        return 0;
    }

    @Override
    public KettleFileRepositoryMeta getRepositoryMeta() {
        return this.repositoryMeta;
    }

    public void setRepositoryMeta(KettleFileRepositoryMeta repositoryMeta) {
        this.repositoryMeta = repositoryMeta;
    }

    @Override
    public void undeleteObject(RepositoryElementMetaInterface repositoryObject) throws KettleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RepositoryElementMetaInterface> getJobAndTransformationObjects(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        ArrayList<RepositoryElementMetaInterface> objs = new ArrayList<RepositoryElementMetaInterface>();
        objs.addAll(this.getJobObjects(id_directory, includeDeleted));
        objs.addAll(this.getTransformationObjects(id_directory, includeDeleted));
        return objs;
    }

    @Override
    public IRepositoryService getService(Class<? extends IRepositoryService> clazz) throws KettleException {
        return this.serviceMap.get(clazz);
    }

    @Override
    public List<Class<? extends IRepositoryService>> getServiceInterfaces() throws KettleException {
        return this.serviceList;
    }

    @Override
    public boolean hasService(Class<? extends IRepositoryService> clazz) throws KettleException {
        return this.serviceMap.containsKey(clazz);
    }

    @Override
    public RepositoryDirectoryInterface getDefaultSaveDirectory(RepositoryElementInterface repositoryElement) throws KettleException {
        return this.getUserHomeDirectory();
    }

    @Override
    public RepositoryDirectoryInterface getUserHomeDirectory() throws KettleException {
        RepositoryDirectory root = new RepositoryDirectory();
        root.setObjectId(null);
        return this.loadRepositoryDirectoryTree((RepositoryDirectoryInterface)root);
    }

    @Override
    public RepositoryObject getObjectInformation(ObjectId objectId, RepositoryObjectType objectType) throws KettleException {
        try {
            String filename = this.calcDirectoryName(null);
            filename = objectId.getId().startsWith("/") ? filename + objectId.getId().substring(1) : filename + objectId.getId();
            FileObject fileObject = KettleVFS.getFileObject((String)filename);
            if (!fileObject.exists()) {
                return null;
            }
            FileName fname = fileObject.getName();
            String name = fname.getBaseName();
            if (!Const.isEmpty((String)fname.getExtension()) && name.length() > fname.getExtension().length()) {
                name = name.substring(0, name.length() - fname.getExtension().length() - 1);
            }
            String filePath = fileObject.getParent().getName().getPath();
            FileObject baseDirObject = KettleVFS.getFileObject((String)this.repositoryMeta.getBaseDirectory());
            int baseDirObjectPathLength = baseDirObject.getName().getPath().length();
            String dirPath = baseDirObjectPathLength <= filePath.length() ? filePath.substring(baseDirObjectPathLength) : "/";
            RepositoryDirectoryInterface directory = this.loadRepositoryDirectoryTree().findDirectory(dirPath);
            Date lastModified = new Date(fileObject.getContent().getLastModifiedTime());
            return new RepositoryObject(objectId, name, directory, "-", lastModified, objectType, "", false);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get object information for object with id=" + objectId, (Throwable)e);
        }
    }

    @Override
    public JobMeta loadJob(ObjectId idJob, String versionLabel) throws KettleException {
        RepositoryObject jobInfo = this.getObjectInformation(idJob, RepositoryObjectType.JOB);
        return this.loadJob(jobInfo.getName(), jobInfo.getRepositoryDirectory(), null, versionLabel);
    }

    @Override
    public TransMeta loadTransformation(ObjectId idTransformation, String versionLabel) throws KettleException {
        RepositoryObject jobInfo = this.getObjectInformation(idTransformation, RepositoryObjectType.TRANSFORMATION);
        return this.loadTransformation(jobInfo.getName(), jobInfo.getRepositoryDirectory(), null, true, versionLabel);
    }

    @Override
    public String getConnectMessage() {
        return null;
    }

    @Override
    public IRepositoryExporter getExporter() {
        return new RepositoryExporter(this);
    }

    @Override
    public IRepositoryImporter getImporter() {
        return new RepositoryImporter(this);
    }

    public XmlMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(XmlMetaStore metaStore) {
        this.metaStore = metaStore;
    }
}

