/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeCategoriesOrder;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginTypeCategoriesOrder(getNaturalCategoriesOrder={"JobCategory.Category.General", "JobCategory.Category.Mail", "JobCategory.Category.FileManagement", "JobCategory.Category.Conditions", "JobCategory.Category.Scripting", "JobCategory.Category.BulkLoading", "JobCategory.Category.BigData", "JobCategory.Category.Modeling", "JobCategory.Category.DataQuality", "JobCategory.Category.XML", "JobCategory.Category.Utility", "JobCategory.Category.Repository", "JobCategory.Category.FileTransfer", "JobCategory.Category.FileEncryption", "JobCategory.Category.Palo", "JobCategory.Category.Experimental", "JobCategory.Category.Deprecated"}, i18nPackageClass=JobMeta.class)
@PluginMainClassType(value=JobEntryInterface.class)
@PluginAnnotationType(value=JobEntry.class)
public class JobEntryPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static Class<?> PKG = JobMeta.class;
    public static final String GENERAL_CATEGORY = BaseMessages.getString(PKG, (String)"JobCategory.Category.General", (String[])new String[0]);
    private static JobEntryPluginType pluginType;

    private JobEntryPluginType() {
        super(JobEntry.class, "JOBENTRY", "Job entry");
        this.populateFolders("jobentries");
    }

    protected JobEntryPluginType(Class<? extends Annotation> pluginType, String id, String name) {
        super(pluginType, id, name);
    }

    public static JobEntryPluginType getInstance() {
        if (pluginType == null) {
            pluginType = new JobEntryPluginType();
        }
        return pluginType;
    }

    public void searchPlugins() throws KettlePluginException {
        this.registerNatives();
        this.registerAnnotations();
        this.registerPluginJars();
        this.registerXmlPlugins();
    }

    protected void registerNatives() throws KettlePluginException {
        String kettleJobEntriesXmlFile = "kettle-job-entries.xml";
        String alternative = System.getProperty("KETTLE_CORE_JOBENTRIES_FILE", null);
        if (!Const.isEmpty((String)alternative)) {
            kettleJobEntriesXmlFile = alternative;
        }
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(kettleJobEntriesXmlFile);
            if (inputStream == null) {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + kettleJobEntriesXmlFile);
            }
            if (inputStream == null && !Const.isEmpty((String)alternative)) {
                try {
                    inputStream = new FileInputStream(kettleJobEntriesXmlFile);
                }
                catch (Exception e) {
                    throw new KettlePluginException("Unable to load native job entries plugins '" + kettleJobEntriesXmlFile + "'", (Throwable)e);
                }
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native step definition file: kettle-job-entries.xml");
            }
            Document document = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)true, (boolean)false);
            Node entriesNode = XMLHandler.getSubNode((Node)document, (String)"job-entries");
            List entryNodes = XMLHandler.getNodes((Node)entriesNode, (String)"job-entry");
            for (Node entryNode : entryNodes) {
                this.registerPluginFromXmlResource(entryNode, null, ((Object)((Object)this)).getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle job entries XML config file: " + kettleJobEntriesXmlFile, (Throwable)e);
        }
    }

    protected void registerAnnotations() throws KettlePluginException {
    }

    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile((FileObject)file);
                    Node pluginNode = XMLHandler.getSubNode((Node)document, (String)"plugin");
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename((FileObject)file.getParent()), ((Object)((Object)this)).getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading job entry plugin.xml file: " + file.getName().toString(), (Throwable)e);
                }
            }
        }
    }

    protected String extractCategory(Annotation annotation) {
        return ((JobEntry)annotation).categoryDescription();
    }

    protected String extractDesc(Annotation annotation) {
        return ((JobEntry)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((JobEntry)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((JobEntry)annotation).name();
    }

    protected String extractImageFile(Annotation annotation) {
        return ((JobEntry)annotation).image();
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return false;
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return ((JobEntry)annotation).i18nPackageName();
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    protected String extractDocumentationUrl(Annotation annotation) {
        return Const.getDocUrl((String)((JobEntry)annotation).documentationUrl());
    }

    protected String extractCasesUrl(Annotation annotation) {
        return ((JobEntry)annotation).casesUrl();
    }

    protected String extractForumUrl(Annotation annotation) {
        return ((JobEntry)annotation).forumUrl();
    }

    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((JobEntry)annotation).classLoaderGroup();
    }
}

