/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.publish.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLEncoder;
import javax.ws.rs.core.MediaType;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.refinery.publish.model.ResponseStatus;

public abstract class BaseRestUtil {
    protected Client getAnonymousClient() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", 2000);
        return Client.create((ClientConfig)clientConfig);
    }

    protected Client getAuthenticatedClient(BiServerConnection connection) {
        Client client = this.getAnonymousClient();
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(connection.getUserId(), connection.getPassword()));
        return client;
    }

    protected WebResource getWebResource(BiServerConnection connection, String restUrl, Client client) {
        String url = connection.getUrl().endsWith("/") ? connection.getUrl() + restUrl : connection.getUrl() + "/" + restUrl;
        return client.resource(url);
    }

    protected ClientResponse httpGet(BiServerConnection connection, String restUrl, boolean authenticate) {
        Client client = this.getAnonymousClient();
        if (authenticate) {
            client = this.getAuthenticatedClient(connection);
        }
        WebResource resource = this.getWebResource(connection, restUrl, client);
        WebResource.Builder builder = this.getDefaultWebResourceBuilder(resource);
        return (ClientResponse)builder.get(ClientResponse.class);
    }

    protected ClientResponse httpPut(BiServerConnection connection, String restUrl, boolean authenticate, Object requestEntity) {
        Client client = this.getAnonymousClient();
        if (authenticate) {
            client = this.getAuthenticatedClient(connection);
        }
        WebResource resource = this.getWebResource(connection, restUrl, client);
        WebResource.Builder builder = this.getDefaultWebResourceBuilder(resource);
        return (ClientResponse)builder.put(ClientResponse.class, requestEntity);
    }

    protected FormDataMultiPart createFileUploadRequest(File file, String repositoryPath) throws Exception {
        FileInputStream in = new FileInputStream(file);
        FormDataMultiPart part = new FormDataMultiPart();
        part.field("importPath", (Object)repositoryPath, MediaType.MULTIPART_FORM_DATA_TYPE).field("fileUpload", (Object)in, MediaType.MULTIPART_FORM_DATA_TYPE).field("overwriteFile", (Object)String.valueOf(true), MediaType.MULTIPART_FORM_DATA_TYPE);
        part.getField("fileUpload").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"fileUpload").fileName(URLEncoder.encode(file.getName(), "UTF-8"))).build());
        return part;
    }

    protected HttpClient getSimpleHttpClient(BiServerConnection connection, boolean authenticate) {
        HttpClient client = new HttpClient();
        if (authenticate) {
            client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(connection.getUserId(), connection.getPassword()));
        }
        return client;
    }

    protected GetMethod createGetMethod(String url, boolean authenticate) {
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(authenticate);
        return get;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseStatus simpleHttpGet(BiServerConnection connection, String restUrl, boolean authenticate) {
        ResponseStatus responseStatus = new ResponseStatus();
        HttpClient client = this.getSimpleHttpClient(connection, authenticate);
        String url = connection.getUrl().endsWith("/") ? connection.getUrl() + restUrl : connection.getUrl() + "/" + restUrl;
        GetMethod get = this.createGetMethod(url, authenticate);
        try {
            client.executeMethod((HttpMethod)get);
            responseStatus.setStatus(get.getStatusCode());
            responseStatus.setMessage(get.getResponseBodyAsString());
        }
        catch (Exception e) {
            responseStatus.setStatus(-1);
            responseStatus.setMessage(e.getMessage());
        }
        finally {
            get.releaseConnection();
        }
        return responseStatus;
    }

    protected WebResource.Builder getDefaultWebResourceBuilder(WebResource webResource) {
        return (WebResource.Builder)((WebResource.Builder)webResource.type("application/json").type("application/xml")).accept(new String[]{"*/*"});
    }
}

