/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.UnionOptimizer;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.udf.ReadScalarsTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezCompilerUtil;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.ReverseDependencyOrderWalker;
import org.apache.pig.impl.plan.VisitorException;

public class MultiQueryOptimizerTez
extends TezOpPlanVisitor {
    private boolean unionOptimizerOn;

    public MultiQueryOptimizerTez(TezOperPlan plan, boolean unionOptimizerOn) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new ReverseDependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        this.unionOptimizerOn = unionOptimizerOn;
    }

    private void addAllPredecessors(TezOperator tezOp, List<TezOperator> predsList) {
        if (((TezOperPlan)this.getPlan()).getPredecessors(tezOp) != null) {
            for (TezOperator pred : ((TezOperPlan)this.getPlan()).getPredecessors(tezOp)) {
                predsList.add(pred);
                this.addAllPredecessors(pred, predsList);
            }
        }
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        try {
            if (!tezOp.isSplitter()) {
                return;
            }
            ArrayList<TezOperator> splittees = new ArrayList<TezOperator>();
            List<TezOperator> successors = ((TezOperPlan)this.getPlan()).getSuccessors(tezOp);
            for (TezOperator successor : successors) {
                ArrayList<TezOperator> predecessors = new ArrayList<TezOperator>(((TezOperPlan)this.getPlan()).getPredecessors(successor));
                predecessors.remove(tezOp);
                if (!predecessors.isEmpty()) {
                    for (TezOperator predecessor : ((TezOperPlan)this.getPlan()).getPredecessors(successor)) {
                        if (predecessor == tezOp) continue;
                        predecessors.add(predecessor);
                        this.addAllPredecessors(predecessor, predecessors);
                    }
                    ArrayList<TezOperator> toMergeSuccPredecessors = new ArrayList<TezOperator>(successors);
                    toMergeSuccPredecessors.remove(successor);
                    for (TezOperator splittee : splittees) {
                        for (TezOperator spliteePred : ((TezOperPlan)this.getPlan()).getPredecessors(splittee)) {
                            if (spliteePred == tezOp) continue;
                            toMergeSuccPredecessors.add(spliteePred);
                            this.addAllPredecessors(spliteePred, toMergeSuccPredecessors);
                        }
                    }
                    if (predecessors.removeAll(toMergeSuccPredecessors)) continue;
                }
                if (successor.getSampleOperator() != null && tezOp.getSampleOperator() != null && !successor.getSampleOperator().equals(tezOp.getSampleOperator())) continue;
                HashSet<TezOperator> mergedSuccessors = new HashSet<TezOperator>();
                HashSet<TezOperator> toMergeSuccessors = new HashSet<TezOperator>();
                mergedSuccessors.addAll(successors);
                for (TezOperator splittee : splittees) {
                    if (((TezOperPlan)this.getPlan()).getSuccessors(splittee) == null) continue;
                    mergedSuccessors.addAll(((TezOperPlan)this.getPlan()).getSuccessors(splittee));
                }
                if (((TezOperPlan)this.getPlan()).getSuccessors(successor) != null) {
                    for (TezOperator succSuccessor : ((TezOperPlan)this.getPlan()).getSuccessors(successor)) {
                        if (succSuccessor.isUnion()) {
                            if (this.unionOptimizerOn && UnionOptimizer.isOptimizable(succSuccessor)) continue;
                            toMergeSuccessors.add(succSuccessor);
                            continue;
                        }
                        if (!successors.contains(succSuccessor)) continue;
                        toMergeSuccessors.add(succSuccessor);
                    }
                }
                mergedSuccessors.retainAll(toMergeSuccessors);
                if (!mergedSuccessors.isEmpty()) continue;
                splittees.add(successor);
            }
            if (splittees.size() == 0) {
                return;
            }
            if (splittees.size() == 1 && successors.size() == 1) {
                PhysicalOperator firstNodeLeaf = (PhysicalOperator)tezOp.plan.getLeaves().get(0);
                PhysicalOperator firstNodeLeafPred = tezOp.plan.getPredecessors(firstNodeLeaf).get(0);
                TezOperator singleSplitee = (TezOperator)splittees.get(0);
                PhysicalOperator secondNodeRoot = (PhysicalOperator)singleSplitee.plan.getRoots().get(0);
                PhysicalOperator secondNodeSucc = singleSplitee.plan.getSuccessors(secondNodeRoot).get(0);
                tezOp.plan.remove(firstNodeLeaf);
                singleSplitee.plan.remove(secondNodeRoot);
                tezOp.plan.merge(singleSplitee.plan);
                tezOp.plan.connect(firstNodeLeafPred, secondNodeSucc);
                this.addSubPlanPropertiesToParent(tezOp, singleSplitee);
                this.removeSplittee((TezOperPlan)this.getPlan(), tezOp, singleSplitee);
            } else {
                POValueOutputTez valueOutput = (POValueOutputTez)tezOp.plan.getLeaves().get(0);
                POSplit split = new POSplit(OperatorKey.genOpKey(valueOutput.getOperatorKey().getScope()));
                split.copyAliasFrom(valueOutput);
                for (TezOperator splitee : splittees) {
                    PhysicalOperator spliteeRoot = (PhysicalOperator)splitee.plan.getRoots().get(0);
                    splitee.plan.remove(spliteeRoot);
                    split.addPlan(splitee.plan);
                    this.addSubPlanPropertiesToParent(tezOp, splitee);
                    this.removeSplittee((TezOperPlan)this.getPlan(), tezOp, splitee);
                    valueOutput.removeOutputKey(splitee.getOperatorKey().toString());
                }
                if (valueOutput.getTezOutputs().length > 0) {
                    PhysicalPlan phyPlan = new PhysicalPlan();
                    phyPlan.addAsLeaf(valueOutput);
                    split.addPlan(phyPlan);
                }
                PhysicalOperator pred = tezOp.plan.getPredecessors(valueOutput).get(0);
                tezOp.plan.disconnect(pred, valueOutput);
                tezOp.plan.remove(valueOutput);
                tezOp.plan.add(split);
                tezOp.plan.connect(pred, split);
            }
        }
        catch (PlanException e) {
            throw new VisitorException(e);
        }
    }

    private void removeSplittee(TezOperPlan plan, TezOperator splitter, TezOperator splittee) throws PlanException, VisitorException {
        plan.disconnect(splitter, splittee);
        String spliteeKey = splittee.getOperatorKey().toString();
        String splitterKey = splitter.getOperatorKey().toString();
        if (plan.getPredecessors(splittee) != null) {
            for (TezOperator pred : new ArrayList<TezOperator>(plan.getPredecessors(splittee))) {
                LinkedList<TezOutput> tezOutputs = PlanHelper.getPhysicalOperators(pred.plan, TezOutput.class);
                for (TezOutput tezOut : tezOutputs) {
                    if (!ArrayUtils.contains((Object[])tezOut.getTezOutputs(), (Object)spliteeKey)) continue;
                    tezOut.replaceOutput(spliteeKey, splitterKey);
                }
                TezEdgeDescriptor edge = pred.outEdges.remove(splittee.getOperatorKey());
                if (edge == null) {
                    throw new VisitorException("Edge description is empty");
                }
                pred.outEdges.put(splitter.getOperatorKey(), edge);
                splitter.inEdges.put(pred.getOperatorKey(), edge);
                plan.disconnect(pred, splittee);
                plan.connect(pred, splitter);
            }
        }
        if (plan.getSuccessors(splittee) != null) {
            ArrayList<TezOperator> succs = new ArrayList<TezOperator>(plan.getSuccessors(splittee));
            List<TezOperator> splitterSuccs = plan.getSuccessors(splitter);
            for (TezOperator succTezOperator : succs) {
                TezEdgeDescriptor edge = succTezOperator.inEdges.get(splittee.getOperatorKey());
                splitter.outEdges.remove(splittee.getOperatorKey());
                succTezOperator.inEdges.remove(splittee.getOperatorKey());
                plan.disconnect(splittee, succTezOperator);
                if (splitterSuccs == null || !splitterSuccs.contains(succTezOperator)) {
                    TezCompilerUtil.connectNoLRReconnect(plan, splitter, succTezOperator, edge);
                }
                try {
                    LinkedList<TezInput> inputs = PlanHelper.getPhysicalOperators(succTezOperator.plan, TezInput.class);
                    for (TezInput input : inputs) {
                        input.replaceInput(spliteeKey, splitterKey);
                    }
                    LinkedList<POUserFunc> userFuncs = PlanHelper.getPhysicalOperators(succTezOperator.plan, POUserFunc.class);
                    for (POUserFunc userFunc : userFuncs) {
                        if (!(userFunc.getFunc() instanceof ReadScalarsTez)) continue;
                        TezInput tezInput = (TezInput)((Object)userFunc.getFunc());
                        tezInput.replaceInput(spliteeKey, splitterKey);
                        userFunc.getFuncSpec().setCtorArgs(tezInput.getTezInputs());
                    }
                }
                catch (VisitorException e) {
                    throw new PlanException(e);
                }
                if (!succTezOperator.isUnion()) continue;
                int index = succTezOperator.getUnionMembers().indexOf(splittee.getOperatorKey());
                while (index > -1) {
                    succTezOperator.getUnionMembers().set(index, splitter.getOperatorKey());
                    index = succTezOperator.getUnionMembers().indexOf(splittee.getOperatorKey());
                }
            }
        }
        plan.remove(splittee);
    }

    private void addSubPlanPropertiesToParent(TezOperator parentOper, TezOperator subPlanOper) {
        if (subPlanOper.getCrossKeys() != null) {
            for (String string : subPlanOper.getCrossKeys()) {
                parentOper.addCrossKey(string);
            }
        }
        parentOper.copyFeatures(subPlanOper, null);
        if (subPlanOper.getSampleOperator() != null) {
            parentOper.setSampleOperator(subPlanOper.getSampleOperator());
        }
        if (subPlanOper.getRequestedParallelism() > parentOper.getRequestedParallelism()) {
            parentOper.setRequestedParallelism(subPlanOper.getRequestedParallelism());
        }
        subPlanOper.setRequestedParallelismByReference(parentOper);
        parentOper.UDFs.addAll(subPlanOper.UDFs);
        parentOper.scalars.addAll(subPlanOper.scalars);
        if (subPlanOper.outEdges != null) {
            for (Map.Entry entry : subPlanOper.outEdges.entrySet()) {
                parentOper.outEdges.put((OperatorKey)entry.getKey(), (TezEdgeDescriptor)entry.getValue());
            }
        }
    }
}

