/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase.table;

import com.pentaho.big.data.bundles.impl.shim.hbase.BatchHBaseConnectionOperation;
import com.pentaho.big.data.bundles.impl.shim.hbase.HBaseConnectionOperation;
import com.pentaho.big.data.bundles.impl.shim.hbase.HBaseConnectionWrapper;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionHandle;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionPool;
import com.pentaho.big.data.bundles.impl.shim.hbase.meta.HBaseValueMetaInterfaceFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.meta.HBaseValueMetaInterfaceImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.table.ResultScannerImpl;
import java.io.IOException;
import org.pentaho.bigdata.api.hbase.mapping.ColumnFilter;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.bigdata.api.hbase.table.ResultScanner;
import org.pentaho.bigdata.api.hbase.table.ResultScannerBuilder;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hbase.shim.api.ColumnFilter;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;

public class ResultScannerBuilderImpl
implements ResultScannerBuilder {
    private final HBaseConnectionPool hBaseConnectionPool;
    private final HBaseValueMetaInterfaceFactoryImpl hBaseValueMetaInterfaceFactory;
    private final HBaseBytesUtilShim hBaseBytesUtilShim;
    private final BatchHBaseConnectionOperation batchHBaseConnectionOperation;
    private int caching = 0;
    private String tableName;

    public ResultScannerBuilderImpl(HBaseConnectionPool hBaseConnectionPool, HBaseValueMetaInterfaceFactoryImpl hBaseValueMetaInterfaceFactory, HBaseBytesUtilShim hBaseBytesUtilShim, String tableName, final byte[] keyLowerBound, final byte[] keyUpperBound) {
        this.hBaseConnectionPool = hBaseConnectionPool;
        this.hBaseValueMetaInterfaceFactory = hBaseValueMetaInterfaceFactory;
        this.hBaseBytesUtilShim = hBaseBytesUtilShim;
        this.batchHBaseConnectionOperation = new BatchHBaseConnectionOperation();
        this.tableName = tableName;
        this.batchHBaseConnectionOperation.addOperation(new HBaseConnectionOperation(){

            @Override
            public void perform(HBaseConnectionWrapper hBaseConnectionWrapper) throws IOException {
                try {
                    hBaseConnectionWrapper.newSourceTableScan(keyLowerBound, keyUpperBound, ResultScannerBuilderImpl.this.caching);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        });
    }

    public void addColumnToScan(final String colFamilyName, final String colName, final boolean colNameIsBinary) throws IOException {
        this.batchHBaseConnectionOperation.addOperation(new HBaseConnectionOperation(){

            @Override
            public void perform(HBaseConnectionWrapper hBaseConnectionWrapper) throws IOException {
                try {
                    hBaseConnectionWrapper.addColumnToScan(colFamilyName, colName, colNameIsBinary);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        });
    }

    public void addColumnFilterToScan(ColumnFilter cf, HBaseValueMetaInterface columnMeta, final VariableSpace vars, final boolean matchAny) throws IOException {
        final org.pentaho.hbase.shim.api.ColumnFilter columnFilter = new org.pentaho.hbase.shim.api.ColumnFilter(cf.getFieldAlias());
        columnFilter.setFormat(cf.getFormat());
        columnFilter.setConstant(cf.getConstant());
        columnFilter.setSignedComparison(cf.getSignedComparison());
        columnFilter.setFieldType(cf.getFieldType());
        columnFilter.setComparisonOperator(ColumnFilter.ComparisonType.valueOf((String)cf.getComparisonOperator().name()));
        final HBaseValueMetaInterfaceImpl hBaseValueMetaInterface = this.hBaseValueMetaInterfaceFactory.copy(columnMeta);
        this.batchHBaseConnectionOperation.addOperation(new HBaseConnectionOperation(){

            @Override
            public void perform(HBaseConnectionWrapper hBaseConnectionWrapper) throws IOException {
                try {
                    hBaseConnectionWrapper.addColumnFilterToScan(columnFilter, hBaseValueMetaInterface, vars, matchAny);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        });
    }

    public void setCaching(int cacheSize) {
        this.caching = cacheSize;
    }

    public ResultScanner build() throws IOException {
        HBaseConnectionHandle connectionHandle = this.hBaseConnectionPool.getConnectionHandle(this.tableName);
        this.batchHBaseConnectionOperation.perform(connectionHandle.getConnection());
        try {
            connectionHandle.getConnection().executeSourceTableScan();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new ResultScannerImpl(connectionHandle, this.hBaseBytesUtilShim);
    }
}

