/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaTableUtil {
    private static final Log LOG = LogFactory.getLog(QuotaTableUtil.class);
    public static final TableName QUOTA_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"quota");
    protected static final byte[] QUOTA_FAMILY_INFO = Bytes.toBytes((String)"q");
    protected static final byte[] QUOTA_FAMILY_USAGE = Bytes.toBytes((String)"u");
    protected static final byte[] QUOTA_QUALIFIER_SETTINGS = Bytes.toBytes((String)"s");
    protected static final byte[] QUOTA_QUALIFIER_SETTINGS_PREFIX = Bytes.toBytes((String)"s.");
    protected static final byte[] QUOTA_USER_ROW_KEY_PREFIX = Bytes.toBytes((String)"u.");
    protected static final byte[] QUOTA_TABLE_ROW_KEY_PREFIX = Bytes.toBytes((String)"t.");
    protected static final byte[] QUOTA_NAMESPACE_ROW_KEY_PREFIX = Bytes.toBytes((String)"n.");

    public static QuotaProtos.Quotas getTableQuota(Configuration conf, TableName table) throws IOException {
        return QuotaTableUtil.getQuotas(conf, QuotaTableUtil.getTableRowKey(table));
    }

    public static QuotaProtos.Quotas getNamespaceQuota(Configuration conf, String namespace) throws IOException {
        return QuotaTableUtil.getQuotas(conf, QuotaTableUtil.getNamespaceRowKey(namespace));
    }

    public static QuotaProtos.Quotas getUserQuota(Configuration conf, String user) throws IOException {
        return QuotaTableUtil.getQuotas(conf, QuotaTableUtil.getUserRowKey(user));
    }

    public static QuotaProtos.Quotas getUserQuota(Configuration conf, String user, TableName table) throws IOException {
        return QuotaTableUtil.getQuotas(conf, QuotaTableUtil.getUserRowKey(user), QuotaTableUtil.getSettingsQualifierForUserTable(table));
    }

    public static QuotaProtos.Quotas getUserQuota(Configuration conf, String user, String namespace) throws IOException {
        return QuotaTableUtil.getQuotas(conf, QuotaTableUtil.getUserRowKey(user), QuotaTableUtil.getSettingsQualifierForUserNamespace(namespace));
    }

    private static QuotaProtos.Quotas getQuotas(Configuration conf, byte[] rowKey) throws IOException {
        return QuotaTableUtil.getQuotas(conf, rowKey, QUOTA_QUALIFIER_SETTINGS);
    }

    private static QuotaProtos.Quotas getQuotas(Configuration conf, byte[] rowKey, byte[] qualifier) throws IOException {
        Get get = new Get(rowKey);
        get.addColumn(QUOTA_FAMILY_INFO, qualifier);
        Result result = QuotaTableUtil.doGet(conf, get);
        if (result.isEmpty()) {
            return null;
        }
        return QuotaTableUtil.quotasFromData(result.getValue(QUOTA_FAMILY_INFO, qualifier));
    }

    public static Get makeGetForTableQuotas(TableName table) {
        Get get = new Get(QuotaTableUtil.getTableRowKey(table));
        get.addFamily(QUOTA_FAMILY_INFO);
        return get;
    }

    public static Get makeGetForNamespaceQuotas(String namespace) {
        Get get = new Get(QuotaTableUtil.getNamespaceRowKey(namespace));
        get.addFamily(QUOTA_FAMILY_INFO);
        return get;
    }

    public static Get makeGetForUserQuotas(String user, Iterable<TableName> tables, Iterable<String> namespaces) {
        Get get = new Get(QuotaTableUtil.getUserRowKey(user));
        get.addColumn(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        for (TableName table : tables) {
            get.addColumn(QUOTA_FAMILY_INFO, QuotaTableUtil.getSettingsQualifierForUserTable(table));
        }
        for (String ns : namespaces) {
            get.addColumn(QUOTA_FAMILY_INFO, QuotaTableUtil.getSettingsQualifierForUserNamespace(ns));
        }
        return get;
    }

    public static Scan makeScan(QuotaFilter filter) {
        Scan scan = new Scan();
        scan.addFamily(QUOTA_FAMILY_INFO);
        if (filter != null && !filter.isNull()) {
            scan.setFilter(QuotaTableUtil.makeFilter(filter));
        }
        return scan;
    }

    public static Filter makeFilter(QuotaFilter filter) {
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        if (!Strings.isEmpty((String)filter.getUserFilter())) {
            FilterList userFilters = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            boolean hasFilter = false;
            if (!Strings.isEmpty((String)filter.getNamespaceFilter())) {
                FilterList nsFilters = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                nsFilters.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getUserRowKeyRegex(filter.getUserFilter()), 0)));
                nsFilters.addFilter(new QualifierFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getSettingsQualifierRegexForUserNamespace(filter.getNamespaceFilter()), 0)));
                userFilters.addFilter(nsFilters);
                hasFilter = true;
            }
            if (!Strings.isEmpty((String)filter.getTableFilter())) {
                FilterList tableFilters = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                tableFilters.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getUserRowKeyRegex(filter.getUserFilter()), 0)));
                tableFilters.addFilter(new QualifierFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getSettingsQualifierRegexForUserTable(filter.getTableFilter()), 0)));
                userFilters.addFilter(tableFilters);
                hasFilter = true;
            }
            if (!hasFilter) {
                userFilters.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getUserRowKeyRegex(filter.getUserFilter()), 0)));
            }
            filterList.addFilter(userFilters);
        } else if (!Strings.isEmpty((String)filter.getTableFilter())) {
            filterList.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getTableRowKeyRegex(filter.getTableFilter()), 0)));
        } else if (!Strings.isEmpty((String)filter.getNamespaceFilter())) {
            filterList.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getNamespaceRowKeyRegex(filter.getNamespaceFilter()), 0)));
        }
        return filterList;
    }

    public static void parseResult(Result result, QuotasVisitor visitor) throws IOException {
        byte[] row = result.getRow();
        if (QuotaTableUtil.isNamespaceRowKey(row)) {
            QuotaTableUtil.parseNamespaceResult(result, visitor);
        } else if (QuotaTableUtil.isTableRowKey(row)) {
            QuotaTableUtil.parseTableResult(result, visitor);
        } else if (QuotaTableUtil.isUserRowKey(row)) {
            QuotaTableUtil.parseUserResult(result, visitor);
        } else {
            LOG.warn((Object)("unexpected row-key: " + Bytes.toString((byte[])row)));
        }
    }

    public static void parseNamespaceResult(Result result, NamespaceQuotasVisitor visitor) throws IOException {
        String namespace = QuotaTableUtil.getNamespaceFromRowKey(result.getRow());
        QuotaTableUtil.parseNamespaceResult(namespace, result, visitor);
    }

    protected static void parseNamespaceResult(String namespace, Result result, NamespaceQuotasVisitor visitor) throws IOException {
        byte[] data = result.getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        if (data != null) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData(data);
            visitor.visitNamespaceQuotas(namespace, quotas);
        }
    }

    public static void parseTableResult(Result result, TableQuotasVisitor visitor) throws IOException {
        TableName table = QuotaTableUtil.getTableFromRowKey(result.getRow());
        QuotaTableUtil.parseTableResult(table, result, visitor);
    }

    protected static void parseTableResult(TableName table, Result result, TableQuotasVisitor visitor) throws IOException {
        byte[] data = result.getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        if (data != null) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData(data);
            visitor.visitTableQuotas(table, quotas);
        }
    }

    public static void parseUserResult(Result result, UserQuotasVisitor visitor) throws IOException {
        String userName = QuotaTableUtil.getUserFromRowKey(result.getRow());
        QuotaTableUtil.parseUserResult(userName, result, visitor);
    }

    protected static void parseUserResult(String userName, Result result, UserQuotasVisitor visitor) throws IOException {
        NavigableMap<byte[], byte[]> familyMap = result.getFamilyMap(QUOTA_FAMILY_INFO);
        if (familyMap == null || familyMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : familyMap.entrySet()) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData((byte[])entry.getValue());
            if (Bytes.startsWith((byte[])((byte[])entry.getKey()), (byte[])QUOTA_QUALIFIER_SETTINGS_PREFIX)) {
                String name = Bytes.toString((byte[])((byte[])entry.getKey()), (int)QUOTA_QUALIFIER_SETTINGS_PREFIX.length);
                if (name.charAt(name.length() - 1) == ':') {
                    String namespace = name.substring(0, name.length() - 1);
                    visitor.visitUserQuotas(userName, namespace, quotas);
                    continue;
                }
                TableName table = TableName.valueOf((String)name);
                visitor.visitUserQuotas(userName, table, quotas);
                continue;
            }
            if (!Bytes.equals((byte[])((byte[])entry.getKey()), (byte[])QUOTA_QUALIFIER_SETTINGS)) continue;
            visitor.visitUserQuotas(userName, quotas);
        }
    }

    protected static QuotaProtos.Quotas quotasFromData(byte[] data) throws IOException {
        int magicLen = ProtobufUtil.lengthOfPBMagic();
        if (!ProtobufUtil.isPBMagicPrefix(data, 0, magicLen)) {
            throw new IOException("Missing pb magic prefix");
        }
        return QuotaProtos.Quotas.parseFrom((InputStream)new ByteArrayInputStream(data, magicLen, data.length - magicLen));
    }

    protected static byte[] quotasToData(QuotaProtos.Quotas data) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(ProtobufUtil.PB_MAGIC);
        data.writeTo((OutputStream)stream);
        return stream.toByteArray();
    }

    public static boolean isEmptyQuota(QuotaProtos.Quotas quotas) {
        boolean hasSettings = false;
        hasSettings |= quotas.hasThrottle();
        return !(hasSettings |= quotas.hasBypassGlobals());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Result doGet(Configuration conf, Get get) throws IOException {
        try (HTable table = new HTable(conf, QUOTA_TABLE_NAME);){
            Result result = table.get(get);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Result[] doGet(Configuration conf, List<Get> gets) throws IOException {
        try (HTable table = new HTable(conf, QUOTA_TABLE_NAME);){
            Result[] resultArray = table.get(gets);
            return resultArray;
        }
    }

    protected static byte[] getUserRowKey(String user) {
        return Bytes.add((byte[])QUOTA_USER_ROW_KEY_PREFIX, (byte[])Bytes.toBytes((String)user));
    }

    protected static byte[] getTableRowKey(TableName table) {
        return Bytes.add((byte[])QUOTA_TABLE_ROW_KEY_PREFIX, (byte[])table.getName());
    }

    protected static byte[] getNamespaceRowKey(String namespace) {
        return Bytes.add((byte[])QUOTA_NAMESPACE_ROW_KEY_PREFIX, (byte[])Bytes.toBytes((String)namespace));
    }

    protected static byte[] getSettingsQualifierForUserTable(TableName tableName) {
        return Bytes.add((byte[])QUOTA_QUALIFIER_SETTINGS_PREFIX, (byte[])tableName.getName());
    }

    protected static byte[] getSettingsQualifierForUserNamespace(String namespace) {
        return Bytes.add((byte[])QUOTA_QUALIFIER_SETTINGS_PREFIX, (byte[])Bytes.toBytes((String)(namespace + ':')));
    }

    protected static String getUserRowKeyRegex(String user) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_USER_ROW_KEY_PREFIX, user);
    }

    protected static String getTableRowKeyRegex(String table) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_TABLE_ROW_KEY_PREFIX, table);
    }

    protected static String getNamespaceRowKeyRegex(String namespace) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_NAMESPACE_ROW_KEY_PREFIX, namespace);
    }

    private static String getRowKeyRegEx(byte[] prefix, String regex) {
        return '^' + Pattern.quote(Bytes.toString((byte[])prefix)) + regex + '$';
    }

    protected static String getSettingsQualifierRegexForUserTable(String table) {
        return '^' + Pattern.quote(Bytes.toString((byte[])QUOTA_QUALIFIER_SETTINGS_PREFIX)) + table + "(?<!" + Pattern.quote(Character.toString(':')) + ")$";
    }

    protected static String getSettingsQualifierRegexForUserNamespace(String namespace) {
        return '^' + Pattern.quote(Bytes.toString((byte[])QUOTA_QUALIFIER_SETTINGS_PREFIX)) + namespace + Pattern.quote(Character.toString(':')) + '$';
    }

    protected static boolean isNamespaceRowKey(byte[] key) {
        return Bytes.startsWith((byte[])key, (byte[])QUOTA_NAMESPACE_ROW_KEY_PREFIX);
    }

    protected static String getNamespaceFromRowKey(byte[] key) {
        return Bytes.toString((byte[])key, (int)QUOTA_NAMESPACE_ROW_KEY_PREFIX.length);
    }

    protected static boolean isTableRowKey(byte[] key) {
        return Bytes.startsWith((byte[])key, (byte[])QUOTA_TABLE_ROW_KEY_PREFIX);
    }

    protected static TableName getTableFromRowKey(byte[] key) {
        return TableName.valueOf((String)Bytes.toString((byte[])key, (int)QUOTA_TABLE_ROW_KEY_PREFIX.length));
    }

    protected static boolean isUserRowKey(byte[] key) {
        return Bytes.startsWith((byte[])key, (byte[])QUOTA_USER_ROW_KEY_PREFIX);
    }

    protected static String getUserFromRowKey(byte[] key) {
        return Bytes.toString((byte[])key, (int)QUOTA_USER_ROW_KEY_PREFIX.length);
    }

    public static interface QuotasVisitor
    extends UserQuotasVisitor,
    TableQuotasVisitor,
    NamespaceQuotasVisitor {
    }

    public static interface NamespaceQuotasVisitor {
        public void visitNamespaceQuotas(String var1, QuotaProtos.Quotas var2) throws IOException;
    }

    public static interface TableQuotasVisitor {
        public void visitTableQuotas(TableName var1, QuotaProtos.Quotas var2) throws IOException;
    }

    public static interface UserQuotasVisitor {
        public void visitUserQuotas(String var1, QuotaProtos.Quotas var2) throws IOException;

        public void visitUserQuotas(String var1, TableName var2, QuotaProtos.Quotas var3) throws IOException;

        public void visitUserQuotas(String var1, String var2, QuotaProtos.Quotas var3) throws IOException;
    }
}

