/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.emr310;

import java.io.IOException;
import org.apache.commons.vfs2.provider.FileProvider;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.fs.FileSystem;
import org.pentaho.hadoop.shim.common.FileSystemProxyV2;
import org.pentaho.hadoop.shim.common.HadoopShimImpl;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hdfs.vfs.HDFSFileProvider;

public class HadoopShim
extends HadoopShimImpl {
    @Override
    public void onLoad(HadoopConfiguration config, HadoopConfigurationFileSystemManager fsm) throws Exception {
        super.onLoad(config, fsm);
        if (!fsm.hasProvider("s3n")) {
            fsm.addProvider(config, "s3n", config.getIdentifier(), (FileProvider)new HDFSFileProvider());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(Configuration conf) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            FileSystemProxyV2 fileSystemProxyV2 = new FileSystemProxyV2(ShimUtils.asConfiguration(conf));
            return fileSystemProxyV2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

