/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.ImpalaDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.plugins.DatabaseMetaPlugin;
import org.pentaho.di.core.row.ValueMetaInterface;

@DatabaseMetaPlugin(type="IMPALASIMBA", typeDescription="Cloudera Impala")
public class ImpalaSimbaDatabaseMeta
extends ImpalaDatabaseMeta
implements DatabaseInterface {
    protected static final String JAR_FILE = "ImpalaJDBC41.jar";
    protected static final String JDBC_URL_PREFIX = "jdbc:impala://";
    protected static final String DRIVER_CLASS_NAME = "org.apache.hive.jdbc.ImpalaSimbaDriver";
    protected static final String JDBC_URL_TEMPLATE = "jdbc:impala://%s:%d/%s;AuthMech=%d%s";
    public static final String ODBC_DRIVER_CLASS_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String KRB_HOST_FQDN = "KrbHostFQDN";
    public static final String KRB_SERVICE_NAME = "KrbServiceName";

    public ImpalaSimbaDatabaseMeta() throws Throwable {
    }

    ImpalaSimbaDatabaseMeta(int majorVersion, int minorVersion) throws Throwable {
        this.driverMajorVersion = majorVersion;
        this.driverMinorVersion = minorVersion;
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return ODBC_DRIVER_CLASS_NAME;
        }
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) throws KettleDatabaseException {
        Integer portNumber = Const.isEmpty((String)port) ? Integer.valueOf(this.getDefaultDatabasePort()) : Integer.valueOf(port);
        if (Const.isEmpty((String)databaseName)) {
            databaseName = "default";
        }
        switch (this.getAccessType()) {
            case 1: {
                return String.format("jdbc:odbc:%s", databaseName);
            }
            case 4: {
                return "Url is configured through JNDI";
            }
        }
        Integer authMethod = 0;
        StringBuilder additional = new StringBuilder();
        String userName = this.getUsername();
        String password = this.getPassword();
        String krbFQDN = this.getProperty(KRB_HOST_FQDN);
        String extraKrbFQDN = this.getExtraProperty(KRB_HOST_FQDN);
        String krbPrincipal = this.getProperty(KRB_SERVICE_NAME);
        String extraKrbPrincipal = this.getExtraProperty(KRB_SERVICE_NAME);
        if (!(Const.isEmpty((String)krbPrincipal) && Const.isEmpty((String)extraKrbPrincipal) || Const.isEmpty((String)krbFQDN) && Const.isEmpty((String)extraKrbFQDN))) {
            authMethod = 1;
        } else if (!Const.isEmpty((String)userName)) {
            additional.append(";UID=");
            additional.append(userName);
            if (!Const.isEmpty((String)password)) {
                authMethod = 3;
                additional.append(";PWD=");
                additional.append(password);
            } else {
                authMethod = 2;
            }
        }
        return String.format(JDBC_URL_TEMPLATE, hostname, portNumber, databaseName, authMethod, additional);
    }

    private String getExtraProperty(String key) {
        return this.getAttributes().getProperty("EXTRA_OPTION_" + this.getPluginId() + "." + key);
    }

    private String getProperty(String key) {
        return this.getAttributes().getProperty(key);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldname, boolean addCr) {
        StringBuilder retval = new StringBuilder();
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldname) {
            retval.append(fieldname).append(' ');
        }
        int type = v.getType();
        switch (type) {
            case 4: {
                retval.append("BOOLEAN");
                break;
            }
            case 3: {
                if (this.isDriverVersion(0, 12)) {
                    retval.append("DATE");
                    break;
                }
                throw new IllegalArgumentException("Date types not supported in this version of Hive");
            }
            case 9: {
                if (this.isDriverVersion(0, 8)) {
                    retval.append("TIMESTAMP");
                    break;
                }
                throw new IllegalArgumentException("Timestamp types not supported in this version of Hive");
            }
            case 2: {
                if (length == 1 && this.isDriverVersion(0, 13)) {
                    retval.append("CHAR");
                    break;
                }
                if (this.isDriverVersion(0, 12)) {
                    retval.append("VARCHAR");
                    break;
                }
                retval.append("STRING");
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval.append("BIGINT");
                            break;
                        }
                        retval.append("FLOAT");
                        break;
                    }
                    retval.append("INT");
                    break;
                }
                if (length > 15) {
                    retval.append("FLOAT");
                    break;
                }
                retval.append("DOUBLE");
            }
        }
        return retval.toString();
    }
}

