/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.MasterCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class QuotaStatusCalls {
    public static QuotaProtos.GetSpaceQuotaRegionSizesResponse getMasterRegionSizes(ClusterConnection clusterConn, int timeout) throws IOException {
        RpcControllerFactory rpcController = clusterConn.getRpcControllerFactory();
        RpcRetryingCallerFactory rpcCaller = clusterConn.getRpcRetryingCallerFactory();
        return QuotaStatusCalls.getMasterRegionSizes(clusterConn, rpcController, rpcCaller, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuotaProtos.GetSpaceQuotaRegionSizesResponse getMasterRegionSizes(Connection conn, RpcControllerFactory factory, RpcRetryingCallerFactory rpcCaller, int timeout) throws IOException {
        RpcRetryingCaller<QuotaProtos.GetSpaceQuotaRegionSizesResponse> caller = rpcCaller.newCaller();
        try (MasterCallable<QuotaProtos.GetSpaceQuotaRegionSizesResponse> callable = new MasterCallable<QuotaProtos.GetSpaceQuotaRegionSizesResponse>(conn, factory){

            @Override
            protected QuotaProtos.GetSpaceQuotaRegionSizesResponse rpcCall() throws Exception {
                return this.master.getSpaceQuotaRegionSizes(this.getRpcController(), RequestConverter.buildGetSpaceQuotaRegionSizesRequest());
            }
        };){
            QuotaProtos.GetSpaceQuotaRegionSizesResponse getSpaceQuotaRegionSizesResponse = caller.callWithoutRetries(callable, timeout);
            return getSpaceQuotaRegionSizesResponse;
        }
    }

    public static QuotaProtos.GetQuotaStatesResponse getMasterQuotaStates(ClusterConnection clusterConn, int timeout) throws IOException {
        RpcControllerFactory rpcController = clusterConn.getRpcControllerFactory();
        RpcRetryingCallerFactory rpcCaller = clusterConn.getRpcRetryingCallerFactory();
        return QuotaStatusCalls.getMasterQuotaStates(clusterConn, rpcController, rpcCaller, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuotaProtos.GetQuotaStatesResponse getMasterQuotaStates(Connection conn, RpcControllerFactory factory, RpcRetryingCallerFactory rpcCaller, int timeout) throws IOException {
        RpcRetryingCaller<QuotaProtos.GetQuotaStatesResponse> caller = rpcCaller.newCaller();
        try (MasterCallable<QuotaProtos.GetQuotaStatesResponse> callable = new MasterCallable<QuotaProtos.GetQuotaStatesResponse>(conn, factory){

            @Override
            protected QuotaProtos.GetQuotaStatesResponse rpcCall() throws Exception {
                return this.master.getQuotaStates(this.getRpcController(), RequestConverter.buildGetQuotaStatesRequest());
            }
        };){
            QuotaProtos.GetQuotaStatesResponse getQuotaStatesResponse = caller.callWithoutRetries(callable, timeout);
            return getQuotaStatesResponse;
        }
    }

    public static QuotaProtos.GetSpaceQuotaSnapshotsResponse getRegionServerQuotaSnapshot(ClusterConnection clusterConn, int timeout, ServerName sn) throws IOException {
        RpcControllerFactory rpcController = clusterConn.getRpcControllerFactory();
        return QuotaStatusCalls.getRegionServerQuotaSnapshot(clusterConn, rpcController, timeout, sn);
    }

    public static QuotaProtos.GetSpaceQuotaSnapshotsResponse getRegionServerQuotaSnapshot(ClusterConnection conn, final RpcControllerFactory factory, int timeout, ServerName sn) throws IOException {
        final AdminProtos.AdminService.BlockingInterface admin = conn.getAdmin(sn);
        Callable<QuotaProtos.GetSpaceQuotaSnapshotsResponse> callable = new Callable<QuotaProtos.GetSpaceQuotaSnapshotsResponse>(){

            @Override
            public QuotaProtos.GetSpaceQuotaSnapshotsResponse call() throws Exception {
                return admin.getSpaceQuotaSnapshots((RpcController)factory.newController(), RequestConverter.buildGetSpaceQuotaSnapshotsRequest());
            }
        };
        return ProtobufUtil.call(callable);
    }
}

