/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncClientScanner {
    private final Scan scan;
    private final ScanMetrics scanMetrics;
    private final AdvancedScanResultConsumer consumer;
    private final TableName tableName;
    private final AsyncConnectionImpl conn;
    private final long pauseNs;
    private final int maxAttempts;
    private final long scanTimeoutNs;
    private final long rpcTimeoutNs;
    private final int startLogErrorsCnt;
    private final ScanResultCache resultCache;
    private int openScannerTries;

    public AsyncClientScanner(Scan scan, AdvancedScanResultConsumer consumer, TableName tableName, AsyncConnectionImpl conn, long pauseNs, int maxAttempts, long scanTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        if (scan.getStartRow() == null) {
            scan.withStartRow(HConstants.EMPTY_START_ROW, scan.includeStartRow());
        }
        if (scan.getStopRow() == null) {
            scan.withStopRow(HConstants.EMPTY_END_ROW, scan.includeStopRow());
        }
        this.scan = scan;
        this.consumer = consumer;
        this.tableName = tableName;
        this.conn = conn;
        this.pauseNs = pauseNs;
        this.maxAttempts = maxAttempts;
        this.scanTimeoutNs = scanTimeoutNs;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.resultCache = ConnectionUtils.createScanResultCache(scan);
        if (scan.isScanMetricsEnabled()) {
            this.scanMetrics = new ScanMetrics();
            consumer.onScanMetricsCreated(this.scanMetrics);
        } else {
            this.scanMetrics = null;
        }
    }

    private CompletableFuture<OpenScannerResponse> callOpenScanner(HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub) {
        boolean isRegionServerRemote = ConnectionUtils.isRemote(loc.getHostname());
        ConnectionUtils.incRPCCallsMetrics(this.scanMetrics, isRegionServerRemote);
        if (this.openScannerTries > 1) {
            ConnectionUtils.incRPCRetriesMetrics(this.scanMetrics, isRegionServerRemote);
        }
        ++this.openScannerTries;
        CompletableFuture<OpenScannerResponse> future = new CompletableFuture<OpenScannerResponse>();
        try {
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(loc.getRegionInfo().getRegionName(), this.scan, this.scan.getCaching(), false);
            stub.scan((RpcController)controller, request, resp -> {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                    return;
                }
                future.complete(new OpenScannerResponse(loc, isRegionServerRemote, stub, controller, (ClientProtos.ScanResponse)resp));
            });
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private void startScan(OpenScannerResponse resp) {
        this.conn.callerFactory.scanSingleRegion().id(resp.resp.getScannerId()).location(resp.loc).remote(resp.isRegionServerRemote).scannerLeaseTimeoutPeriod(resp.resp.getTtl(), TimeUnit.MILLISECONDS).stub(resp.stub).setScan(this.scan).metrics(this.scanMetrics).consumer(this.consumer).resultCache(this.resultCache).rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).scanTimeout(this.scanTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt).start(resp.controller, resp.resp).whenComplete((hasMore, error) -> {
            if (error != null) {
                this.consumer.onError((Throwable)error);
                return;
            }
            if (hasMore.booleanValue()) {
                this.openScanner();
            } else {
                this.consumer.onComplete();
            }
        });
    }

    private void openScanner() {
        ConnectionUtils.incRegionCountMetrics(this.scanMetrics);
        this.openScannerTries = 1;
        this.conn.callerFactory.single().table(this.tableName).row(this.scan.getStartRow()).locateType(ConnectionUtils.getLocateType(this.scan)).rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.scanTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt).action(this::callOpenScanner).call().whenComplete((resp, error) -> {
            if (error != null) {
                this.consumer.onError((Throwable)error);
                return;
            }
            this.startScan((OpenScannerResponse)resp);
        });
    }

    public void start() {
        this.openScanner();
    }

    private static final class OpenScannerResponse {
        public final HRegionLocation loc;
        public final boolean isRegionServerRemote;
        public final ClientProtos.ClientService.Interface stub;
        public final HBaseRpcController controller;
        public final ClientProtos.ScanResponse resp;

        public OpenScannerResponse(HRegionLocation loc, boolean isRegionServerRemote, ClientProtos.ClientService.Interface stub, HBaseRpcController controller, ClientProtos.ScanResponse resp) {
            this.loc = loc;
            this.isRegionServerRemote = isRegionServerRemote;
            this.stub = stub;
            this.controller = controller;
            this.resp = resp;
        }
    }
}

