/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.AsyncProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.RingBufferTruck;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.SingleThreadEventExecutor;
import org.apache.htrace.core.TraceScope;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class AsyncFSWAL
extends AbstractFSWAL<WALProvider.AsyncWriter> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncFSWAL.class);
    private static final Comparator<SyncFuture> SEQ_COMPARATOR = (o1, o2) -> {
        int c = Long.compare(o1.getTxid(), o2.getTxid());
        return c != 0 ? c : Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
    };
    public static final String WAL_BATCH_SIZE = "hbase.wal.batch.size";
    public static final long DEFAULT_WAL_BATCH_SIZE = 65536L;
    public static final String ASYNC_WAL_USE_SHARED_EVENT_LOOP = "hbase.wal.async.use-shared-event-loop";
    public static final boolean DEFAULT_ASYNC_WAL_USE_SHARED_EVENT_LOOP = false;
    public static final String ASYNC_WAL_WAIT_ON_SHUTDOWN_IN_SECONDS = "hbase.wal.async.wait.on.shutdown.seconds";
    public static final int DEFAULT_ASYNC_WAL_WAIT_ON_SHUTDOWN_IN_SECONDS = 5;
    private final EventLoopGroup eventLoopGroup;
    private final ExecutorService consumeExecutor;
    private final Class<? extends Channel> channelClass;
    private final Lock consumeLock = new ReentrantLock();
    private final Runnable consumer = this::consume;
    private final Supplier<Boolean> hasConsumerTask;
    private static final int MAX_EPOCH = 0x3FFFFFFF;
    private volatile int epochAndState;
    private boolean rollRequested;
    private boolean readyForRolling;
    private final Condition readyForRollingCond = this.consumeLock.newCondition();
    private final RingBuffer<RingBufferTruck> waitingConsumePayloads;
    private final Sequence waitingConsumePayloadsGatingSequence;
    private final AtomicBoolean consumerScheduled = new AtomicBoolean(false);
    private final long batchSize;
    private final ExecutorService closeExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Close-WAL-Writer-%d").build());
    private volatile AsyncFSOutput fsOut;
    private final Deque<FSWALEntry> toWriteAppends = new ArrayDeque<FSWALEntry>();
    private final Deque<FSWALEntry> unackedAppends = new ArrayDeque<FSWALEntry>();
    private final SortedSet<SyncFuture> syncFutures = new TreeSet<SyncFuture>(SEQ_COMPARATOR);
    private long highestProcessedAppendTxid;
    private long fileLengthAtLastSync;
    private long highestProcessedAppendTxidAtLastSync;
    private final int waitOnShutdownInSeconds;

    public AsyncFSWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws FailedLogCloseException, IOException {
        super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix);
        Supplier<Boolean> hasConsumerTask;
        this.eventLoopGroup = eventLoopGroup;
        this.channelClass = channelClass;
        if (conf.getBoolean(ASYNC_WAL_USE_SHARED_EVENT_LOOP, false)) {
            this.consumeExecutor = eventLoopGroup.next();
            if (this.consumeExecutor instanceof SingleThreadEventExecutor) {
                try {
                    Field field = SingleThreadEventExecutor.class.getDeclaredField("taskQueue");
                    field.setAccessible(true);
                    Queue queue = (Queue)field.get(this.consumeExecutor);
                    hasConsumerTask = () -> queue.peek() == this.consumer;
                }
                catch (Exception e) {
                    LOG.warn("Can not get task queue of " + this.consumeExecutor + ", this is not necessary, just give up", (Throwable)e);
                    hasConsumerTask = () -> false;
                }
            } else {
                hasConsumerTask = () -> false;
            }
        } else {
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("AsyncFSWAL-%d").setDaemon(true).build());
            hasConsumerTask = () -> threadPool.getQueue().peek() == this.consumer;
            this.consumeExecutor = threadPool;
        }
        this.hasConsumerTask = hasConsumerTask;
        int preallocatedEventCount = conf.getInt("hbase.regionserver.wal.disruptor.event.count", 16384);
        this.waitingConsumePayloads = RingBuffer.createMultiProducer(RingBufferTruck::new, (int)preallocatedEventCount);
        this.waitingConsumePayloadsGatingSequence = new Sequence(-1L);
        this.waitingConsumePayloads.addGatingSequences(new Sequence[]{this.waitingConsumePayloadsGatingSequence});
        this.waitingConsumePayloads.publish(this.waitingConsumePayloads.next());
        this.waitingConsumePayloadsGatingSequence.set(this.waitingConsumePayloads.getCursor());
        this.batchSize = conf.getLong(WAL_BATCH_SIZE, 65536L);
        this.waitOnShutdownInSeconds = conf.getInt(ASYNC_WAL_WAIT_ON_SHUTDOWN_IN_SECONDS, 5);
        this.rollWriter();
    }

    private static boolean waitingRoll(int epochAndState) {
        return (epochAndState & 1) != 0;
    }

    private static boolean writerBroken(int epochAndState) {
        return (epochAndState >>> 1 & 1) != 0;
    }

    private static int epoch(int epochAndState) {
        return epochAndState >>> 2;
    }

    private boolean trySetReadyForRolling() {
        if (!AsyncFSWAL.waitingRoll(this.epochAndState) || !this.unackedAppends.isEmpty()) {
            return false;
        }
        this.consumeLock.lock();
        try {
            if (AsyncFSWAL.waitingRoll(this.epochAndState)) {
                this.readyForRolling = true;
                this.readyForRollingCond.signalAll();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.consumeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFailed(long epochWhenSync, Throwable error) {
        LOG.warn("sync failed", error);
        boolean shouldRequestLogRoll = true;
        this.consumeLock.lock();
        try {
            int currentEpochAndState = this.epochAndState;
            if ((long)AsyncFSWAL.epoch(currentEpochAndState) != epochWhenSync || AsyncFSWAL.writerBroken(currentEpochAndState)) {
                return;
            }
            this.epochAndState = currentEpochAndState | 2;
            if (AsyncFSWAL.waitingRoll(currentEpochAndState)) {
                this.readyForRolling = true;
                this.readyForRollingCond.signalAll();
                shouldRequestLogRoll = false;
            }
        }
        finally {
            this.consumeLock.unlock();
        }
        Iterator<FSWALEntry> iter = this.unackedAppends.descendingIterator();
        while (iter.hasNext()) {
            this.toWriteAppends.addFirst(iter.next());
        }
        this.highestUnsyncedTxid = this.highestSyncedTxid.get();
        if (shouldRequestLogRoll) {
            this.requestLogRoll();
        }
    }

    private void syncCompleted(WALProvider.AsyncWriter writer, long processedTxid, long startTimeNs) {
        this.highestSyncedTxid.set(processedTxid);
        Iterator<FSWALEntry> iter = this.unackedAppends.iterator();
        while (iter.hasNext() && iter.next().getTxid() <= processedTxid) {
            iter.remove();
        }
        this.postSync(System.nanoTime() - startTimeNs, this.finishSync(true));
        if (this.trySetReadyForRolling()) {
            return;
        }
        if (writer.getLength() < this.logrollsize || this.rollRequested) {
            return;
        }
        this.rollRequested = true;
        this.requestLogRoll();
    }

    private void sync(WALProvider.AsyncWriter writer) {
        long currentHighestProcessedAppendTxid;
        this.fileLengthAtLastSync = writer.getLength();
        this.highestProcessedAppendTxidAtLastSync = currentHighestProcessedAppendTxid = this.highestProcessedAppendTxid;
        long startTimeNs = System.nanoTime();
        long epoch = (long)this.epochAndState >>> 2;
        writer.sync().whenCompleteAsync((result, error) -> {
            if (error != null) {
                this.syncFailed(epoch, (Throwable)error);
            } else {
                this.syncCompleted(writer, currentHighestProcessedAppendTxid, startTimeNs);
            }
        }, (Executor)this.consumeExecutor);
    }

    private void addTimeAnnotation(SyncFuture future, String annotation) {
        TraceUtil.addTimelineAnnotation((String)annotation);
    }

    private int finishSyncLowerThanTxid(long txid, boolean addSyncTrace) {
        SyncFuture sync;
        int finished = 0;
        Iterator iter = this.syncFutures.iterator();
        while (iter.hasNext() && (sync = (SyncFuture)iter.next()).getTxid() <= txid) {
            sync.done(txid, null);
            iter.remove();
            ++finished;
            if (!addSyncTrace) continue;
            this.addTimeAnnotation(sync, "writer synced");
        }
        return finished;
    }

    private int finishSync(boolean addSyncTrace) {
        if (this.unackedAppends.isEmpty()) {
            if (this.toWriteAppends.isEmpty()) {
                long maxSyncTxid = this.highestSyncedTxid.get();
                for (SyncFuture sync : this.syncFutures) {
                    maxSyncTxid = Math.max(maxSyncTxid, sync.getTxid());
                    sync.done(maxSyncTxid, null);
                    if (!addSyncTrace) continue;
                    this.addTimeAnnotation(sync, "writer synced");
                }
                this.highestSyncedTxid.set(maxSyncTxid);
                int finished = this.syncFutures.size();
                this.syncFutures.clear();
                return finished;
            }
            long lowestUnprocessedAppendTxid = this.toWriteAppends.peek().getTxid();
            assert (lowestUnprocessedAppendTxid > this.highestProcessedAppendTxid);
            long doneTxid = lowestUnprocessedAppendTxid - 1L;
            this.highestSyncedTxid.set(doneTxid);
            return this.finishSyncLowerThanTxid(doneTxid, addSyncTrace);
        }
        long lowestUnackedAppendTxid = this.unackedAppends.peek().getTxid();
        long doneTxid = Math.max(lowestUnackedAppendTxid - 1L, this.highestSyncedTxid.get());
        this.highestSyncedTxid.set(doneTxid);
        return this.finishSyncLowerThanTxid(doneTxid, addSyncTrace);
    }

    private void appendAndSync() {
        WALProvider.AsyncWriter writer = (WALProvider.AsyncWriter)this.writer;
        this.finishSync(false);
        long newHighestProcessedAppendTxid = -1L;
        Iterator<FSWALEntry> iter = this.toWriteAppends.iterator();
        while (iter.hasNext()) {
            boolean appended;
            FSWALEntry entry = iter.next();
            try {
                appended = this.append(writer, entry);
            }
            catch (IOException e) {
                throw new AssertionError("should not happen", e);
            }
            newHighestProcessedAppendTxid = entry.getTxid();
            iter.remove();
            if (!appended) continue;
            this.unackedAppends.addLast(entry);
            if (writer.getLength() - this.fileLengthAtLastSync < this.batchSize) continue;
            break;
        }
        if (newHighestProcessedAppendTxid > 0L) {
            this.highestProcessedAppendTxid = newHighestProcessedAppendTxid;
        } else {
            newHighestProcessedAppendTxid = this.highestProcessedAppendTxid;
        }
        if (writer.getLength() - this.fileLengthAtLastSync >= this.batchSize) {
            this.sync(writer);
            return;
        }
        if (writer.getLength() == this.fileLengthAtLastSync) {
            if (this.unackedAppends.isEmpty()) {
                this.highestSyncedTxid.set(this.highestProcessedAppendTxid);
                this.finishSync(false);
                this.trySetReadyForRolling();
            }
            return;
        }
    }

    private void consume() {
        this.consumeLock.lock();
        try {
            int currentEpochAndState = this.epochAndState;
            if (AsyncFSWAL.writerBroken(currentEpochAndState)) {
                return;
            }
            if (AsyncFSWAL.waitingRoll(currentEpochAndState)) {
                if (((WALProvider.AsyncWriter)this.writer).getLength() > this.fileLengthAtLastSync) {
                    this.sync((WALProvider.AsyncWriter)this.writer);
                } else if (this.unackedAppends.isEmpty()) {
                    this.readyForRolling = true;
                    this.readyForRollingCond.signalAll();
                }
                return;
            }
        }
        finally {
            this.consumeLock.unlock();
        }
        long cursorBound = this.waitingConsumePayloads.getCursor();
        for (long nextCursor = this.waitingConsumePayloadsGatingSequence.get() + 1L; nextCursor <= cursorBound && this.waitingConsumePayloads.isPublished(nextCursor); ++nextCursor) {
            RingBufferTruck truck = (RingBufferTruck)this.waitingConsumePayloads.get(nextCursor);
            switch (truck.type()) {
                case APPEND: {
                    this.toWriteAppends.addLast(truck.unloadAppend());
                    break;
                }
                case SYNC: {
                    this.syncFutures.add(truck.unloadSync());
                    break;
                }
                default: {
                    LOG.warn("RingBufferTruck with unexpected type: " + (Object)((Object)truck.type()));
                }
            }
            this.waitingConsumePayloadsGatingSequence.set(nextCursor);
        }
        this.appendAndSync();
        if (this.hasConsumerTask.get().booleanValue()) {
            return;
        }
        if (this.toWriteAppends.isEmpty() && this.waitingConsumePayloadsGatingSequence.get() == this.waitingConsumePayloads.getCursor()) {
            this.consumerScheduled.set(false);
            if (this.waitingConsumePayloadsGatingSequence.get() == this.waitingConsumePayloads.getCursor()) {
                if (((WALProvider.AsyncWriter)this.writer).getLength() > this.fileLengthAtLastSync && !this.syncFutures.isEmpty() && this.syncFutures.last().getTxid() > this.highestProcessedAppendTxidAtLastSync) {
                    this.sync((WALProvider.AsyncWriter)this.writer);
                }
                return;
            }
            if (!this.consumerScheduled.compareAndSet(false, true)) {
                return;
            }
        }
        this.consumeExecutor.execute(this.consumer);
    }

    private boolean shouldScheduleConsumer() {
        int currentEpochAndState = this.epochAndState;
        if (AsyncFSWAL.writerBroken(currentEpochAndState) || AsyncFSWAL.waitingRoll(currentEpochAndState)) {
            return false;
        }
        return this.consumerScheduled.compareAndSet(false, true);
    }

    @Override
    public long append(RegionInfo hri, WALKeyImpl key, WALEdit edits, boolean inMemstore) throws IOException {
        long txid = this.stampSequenceIdAndPublishToRingBuffer(hri, key, edits, inMemstore, this.waitingConsumePayloads);
        if (this.shouldScheduleConsumer()) {
            this.consumeExecutor.execute(this.consumer);
        }
        return txid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        try (TraceScope scope = TraceUtil.createTrace((String)"AsyncFSWAL.sync");){
            SyncFuture future;
            long txid = this.waitingConsumePayloads.next();
            try {
                future = this.getSyncFuture(txid);
                RingBufferTruck truck = (RingBufferTruck)this.waitingConsumePayloads.get(txid);
                truck.load(future);
            }
            finally {
                this.waitingConsumePayloads.publish(txid);
            }
            if (this.shouldScheduleConsumer()) {
                this.consumeExecutor.execute(this.consumer);
            }
            this.blockOnSync(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(long txid) throws IOException {
        if (this.highestSyncedTxid.get() >= txid) {
            return;
        }
        try (TraceScope scope = TraceUtil.createTrace((String)"AsyncFSWAL.sync");){
            SyncFuture future;
            long sequence = this.waitingConsumePayloads.next();
            try {
                future = this.getSyncFuture(txid);
                RingBufferTruck truck = (RingBufferTruck)this.waitingConsumePayloads.get(sequence);
                truck.load(future);
            }
            finally {
                this.waitingConsumePayloads.publish(sequence);
            }
            if (this.shouldScheduleConsumer()) {
                this.consumeExecutor.execute(this.consumer);
            }
            this.blockOnSync(future);
        }
    }

    @Override
    protected WALProvider.AsyncWriter createWriterInstance(Path path) throws IOException {
        return AsyncFSWALProvider.createAsyncWriter(this.conf, this.fs, path, false, this.blocksize, this.eventLoopGroup, this.channelClass);
    }

    private void waitForSafePoint() {
        this.consumeLock.lock();
        try {
            int currentEpochAndState = this.epochAndState;
            if (AsyncFSWAL.writerBroken(currentEpochAndState) || this.writer == null) {
                return;
            }
            this.consumerScheduled.set(true);
            this.epochAndState = currentEpochAndState | 1;
            this.readyForRolling = false;
            this.consumeExecutor.execute(this.consumer);
            while (!this.readyForRolling) {
                this.readyForRollingCond.awaitUninterruptibly();
            }
        }
        finally {
            this.consumeLock.unlock();
        }
    }

    private long closeWriter() {
        WALProvider.AsyncWriter oldWriter = (WALProvider.AsyncWriter)this.writer;
        if (oldWriter != null) {
            long fileLength = oldWriter.getLength();
            this.closeExecutor.execute(() -> {
                try {
                    oldWriter.close();
                }
                catch (IOException e) {
                    LOG.warn("close old writer failed", (Throwable)e);
                }
            });
            return fileLength;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReplaceWriter(Path oldPath, Path newPath, WALProvider.AsyncWriter nextWriter) throws IOException {
        Preconditions.checkNotNull((Object)nextWriter);
        this.waitForSafePoint();
        long oldFileLen = this.closeWriter();
        this.logRollAndSetupWalProps(oldPath, newPath, oldFileLen);
        this.writer = nextWriter;
        if (nextWriter instanceof AsyncProtobufLogWriter) {
            this.fsOut = ((AsyncProtobufLogWriter)nextWriter).getOutput();
        }
        this.fileLengthAtLastSync = nextWriter.getLength();
        this.rollRequested = false;
        this.highestProcessedAppendTxidAtLastSync = 0L;
        this.consumeLock.lock();
        try {
            this.consumerScheduled.set(true);
            int currentEpoch = this.epochAndState >>> 2;
            int nextEpoch = currentEpoch == 0x3FFFFFFF ? 0 : currentEpoch + 1;
            this.epochAndState = nextEpoch << 2;
            this.consumeExecutor.execute(this.consumer);
        }
        finally {
            this.consumeLock.unlock();
        }
    }

    @Override
    protected void doShutdown() throws IOException {
        this.waitForSafePoint();
        this.closeWriter();
        this.closeExecutor.shutdown();
        try {
            if (!this.closeExecutor.awaitTermination(this.waitOnShutdownInSeconds, TimeUnit.SECONDS)) {
                LOG.error("We have waited " + this.waitOnShutdownInSeconds + " seconds but the close of async writer doesn't complete.Please check the status of underlying filesystem or increase the wait time by the config \"" + ASYNC_WAL_WAIT_ON_SHUTDOWN_IN_SECONDS + "\"");
            }
        }
        catch (InterruptedException e) {
            LOG.error("The wait for close of async writer is interrupted");
            Thread.currentThread().interrupt();
        }
        IOException error = new IOException("WAL has been closed");
        long cursorBound = this.waitingConsumePayloads.getCursor();
        block5: for (long nextCursor = this.waitingConsumePayloadsGatingSequence.get() + 1L; nextCursor <= cursorBound && this.waitingConsumePayloads.isPublished(nextCursor); ++nextCursor) {
            RingBufferTruck truck = (RingBufferTruck)this.waitingConsumePayloads.get(nextCursor);
            switch (truck.type()) {
                case SYNC: {
                    this.syncFutures.add(truck.unloadSync());
                    continue block5;
                }
            }
        }
        this.syncFutures.forEach(f -> f.done(f.getTxid(), error));
        if (!(this.consumeExecutor instanceof EventLoop)) {
            this.consumeExecutor.shutdown();
        }
    }

    @Override
    protected void doAppend(WALProvider.AsyncWriter writer, FSWALEntry entry) {
        writer.append(entry);
    }

    @Override
    DatanodeInfo[] getPipeline() {
        AsyncFSOutput output = this.fsOut;
        return output != null ? output.getPipeline() : new DatanodeInfo[]{};
    }

    @Override
    int getLogReplication() {
        return this.getPipeline().length;
    }

    @Override
    protected boolean doCheckLogLowReplication() {
        AsyncFSOutput output = this.fsOut;
        return output != null && output.isBroken();
    }
}

