/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.api.internal.hbase;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseValueMeta;
import org.w3c.dom.Node;

public class Mapping {
    protected String m_tableName = "";
    protected String m_mappingName = "";
    protected String m_keyName = "";
    protected KeyType m_keyType = KeyType.STRING;
    protected Map<String, HBaseValueMeta> m_mappedColumnsByAlias = new HashMap<String, HBaseValueMeta>();
    protected Map<String, HBaseValueMeta> m_mappedColumnsByFamilyCol = new HashMap<String, HBaseValueMeta>();
    protected boolean m_tupleMapping;
    protected String m_tupleFamilies = "";

    public Mapping() {
        this(null, null, null, null);
    }

    public Mapping(String tableName, String mappingName) {
        this(tableName, mappingName, null, null);
    }

    public Mapping(String tableName, String mappingName, String keyName, KeyType keyType) {
        this.m_tableName = tableName;
        this.m_mappingName = mappingName;
        this.m_keyName = keyName;
        this.m_keyType = keyType;
    }

    public String addMappedColumn(HBaseValueMeta column, boolean isTupleColumn) throws Exception {
        String alias;
        if (!isTupleColumn) {
            if (this.m_mappedColumnsByFamilyCol.get(column.getColumnFamily() + "," + column.getColumnName()) != null) {
                throw new Exception("\"" + column.getColumnFamily() + "," + column.getColumnName() + "\" is already mapped in mapping \"" + this.m_mappingName + "\"");
            }
            this.m_mappedColumnsByFamilyCol.put(column.getColumnFamily() + "," + column.getColumnName(), column);
        }
        if (this.m_mappedColumnsByAlias.get(alias = column.getAlias()) != null) {
            if (alias.lastIndexOf(95) <= 0) {
                alias = alias + "_1";
            } else {
                String tail = alias.substring(alias.lastIndexOf(95) + 1, alias.length());
                try {
                    int copy = Integer.parseInt(tail);
                    alias = alias.substring(0, alias.lastIndexOf(95) + 1);
                    alias = alias + "" + ++copy;
                }
                catch (NumberFormatException e) {
                    alias = alias + "_1";
                }
            }
            column.setAlias(alias);
        }
        this.m_mappedColumnsByAlias.put(alias, column);
        return alias;
    }

    public void setTableName(String tableName) {
        this.m_tableName = tableName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public void setMappingName(String mappingName) {
        this.m_mappingName = mappingName;
    }

    public String getMappingName() {
        return this.m_mappingName;
    }

    public void setKeyName(String keyName) {
        this.m_keyName = keyName;
    }

    public String getKeyName() {
        return this.m_keyName;
    }

    public void setKeyType(KeyType type) {
        this.m_keyType = type;
    }

    public void setKeyTypeAsString(String type) throws Exception {
        boolean found = false;
        for (KeyType k : KeyType.values()) {
            if (!k.toString().equalsIgnoreCase(type)) continue;
            this.m_keyType = k;
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Unknown key type: " + type);
        }
    }

    public KeyType getKeyType() {
        return this.m_keyType;
    }

    public boolean isTupleMapping() {
        return this.m_tupleMapping;
    }

    public void setTupleMapping(boolean t) {
        this.m_tupleMapping = t;
    }

    public String getTupleFamilies() {
        return this.m_tupleFamilies;
    }

    public void setTupleFamilies(String f) {
        this.m_tupleFamilies = f;
    }

    public void setMappedColumns(Map<String, HBaseValueMeta> cols) {
        this.m_mappedColumnsByAlias = cols;
    }

    public Map<String, HBaseValueMeta> getMappedColumns() {
        return this.m_mappedColumnsByAlias;
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        if (Const.isEmpty((String)this.getKeyName())) {
            return;
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "mapping_name", this.getMappingName());
        rep.saveStepAttribute(id_transformation, id_step, 0, "table_name", this.getTableName());
        String keyName = this.getKeyName();
        if (this.isTupleMapping()) {
            keyName = keyName + ",";
            if (!Const.isEmpty((String)this.getTupleFamilies())) {
                keyName = keyName + this.getTupleFamilies();
            }
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "key", keyName);
        rep.saveStepAttribute(id_transformation, id_step, 0, "key_type", this.getKeyType().toString());
        Set<String> aliases = this.m_mappedColumnsByAlias.keySet();
        if (aliases.size() > 0) {
            int i = 0;
            for (String alias : aliases) {
                HBaseValueMeta vm = this.m_mappedColumnsByAlias.get(alias);
                rep.saveStepAttribute(id_transformation, id_step, i, "alias", alias);
                rep.saveStepAttribute(id_transformation, id_step, i, "column_family", vm.getColumnFamily());
                rep.saveStepAttribute(id_transformation, id_step, i, "column_name", vm.getColumnName());
                rep.saveStepAttribute(id_transformation, id_step, i, "type", vm.getHBaseTypeDesc());
                if (vm.getStorageType() == 2) {
                    String nomVals = HBaseValueMeta.objectIndexValuesToString(vm.getIndex());
                    rep.saveStepAttribute(id_transformation, id_step, i, "indexed_vals", nomVals);
                }
                ++i;
            }
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (Const.isEmpty((String)this.getKeyName())) {
            return "";
        }
        retval.append("\n    ").append(XMLHandler.openTag((String)"mapping"));
        retval.append("\n      ").append(XMLHandler.addTagValue((String)"mapping_name", (String)this.getMappingName()));
        retval.append("\n      ").append(XMLHandler.addTagValue((String)"table_name", (String)this.getTableName()));
        String keyName = this.getKeyName();
        if (this.isTupleMapping()) {
            keyName = keyName + ",";
            if (!Const.isEmpty((String)this.getTupleFamilies())) {
                keyName = keyName + this.getTupleFamilies();
            }
        }
        retval.append("\n      ").append(XMLHandler.addTagValue((String)"key", (String)keyName));
        retval.append("\n      ").append(XMLHandler.addTagValue((String)"key_type", (String)this.getKeyType().toString()));
        Set<String> aliases = this.m_mappedColumnsByAlias.keySet();
        if (aliases.size() > 0) {
            retval.append("\n        ").append(XMLHandler.openTag((String)"mapped_columns"));
            for (String alias : aliases) {
                HBaseValueMeta vm = this.m_mappedColumnsByAlias.get(alias);
                retval.append("\n        ").append(XMLHandler.openTag((String)"mapped_column"));
                retval.append("\n          ").append(XMLHandler.addTagValue((String)"alias", (String)alias));
                retval.append("\n          ").append(XMLHandler.addTagValue((String)"column_family", (String)vm.getColumnFamily()));
                retval.append("\n          ").append(XMLHandler.addTagValue((String)"column_name", (String)vm.getColumnName()));
                retval.append("\n          ").append(XMLHandler.addTagValue((String)"type", (String)vm.getHBaseTypeDesc()));
                if (vm.getStorageType() == 2) {
                    String nomVals = HBaseValueMeta.objectIndexValuesToString(vm.getIndex());
                    retval.append("\n          ").append(XMLHandler.addTagValue((String)"indexed_vals", (String)nomVals));
                }
                retval.append("\n        ").append(XMLHandler.closeTag((String)"mapped_column"));
            }
            retval.append("\n        ").append(XMLHandler.closeTag((String)"mapped_columns"));
        }
        retval.append("\n    ").append(XMLHandler.closeTag((String)"mapping"));
        return retval.toString();
    }

    public boolean loadXML(Node stepnode) throws KettleXMLException {
        Node fields;
        if ((stepnode = XMLHandler.getSubNode((Node)stepnode, (String)"mapping")) == null || Const.isEmpty((String)XMLHandler.getTagValue((Node)stepnode, (String)"key"))) {
            return false;
        }
        this.setMappingName(XMLHandler.getTagValue((Node)stepnode, (String)"mapping_name"));
        this.setTableName(XMLHandler.getTagValue((Node)stepnode, (String)"table_name"));
        String keyName = XMLHandler.getTagValue((Node)stepnode, (String)"key");
        if (keyName.indexOf(44) > 0) {
            String familiesList;
            this.setTupleMapping(true);
            this.setKeyName(keyName.substring(0, keyName.indexOf(44)));
            if (keyName.indexOf(44) != keyName.length() - 1 && !Const.isEmpty((String)(familiesList = keyName.substring(keyName.indexOf(44) + 1, keyName.length())).trim())) {
                this.setTupleFamilies(familiesList);
            }
        } else {
            this.setKeyName(keyName);
        }
        String keyTypeS = XMLHandler.getTagValue((Node)stepnode, (String)"key_type");
        for (KeyType k : KeyType.values()) {
            if (!k.toString().equalsIgnoreCase(keyTypeS)) continue;
            this.setKeyType(k);
            break;
        }
        if ((fields = XMLHandler.getSubNode((Node)stepnode, (String)"mapped_columns")) != null && XMLHandler.countNodes((Node)fields, (String)"mapped_column") > 0) {
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"mapped_column");
            for (int i = 0; i < nrfields; ++i) {
                String colName;
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"mapped_column", (int)i);
                String alias = XMLHandler.getTagValue((Node)fieldNode, (String)"alias");
                String colFam = XMLHandler.getTagValue((Node)fieldNode, (String)"column_family");
                if (colFam == null) {
                    colFam = "";
                }
                if ((colName = XMLHandler.getTagValue((Node)fieldNode, (String)"column_name")) == null) {
                    colName = "";
                }
                String type = XMLHandler.getTagValue((Node)fieldNode, (String)"type");
                String combined = colFam + "," + colName + "," + alias;
                HBaseValueMeta hbvm = new HBaseValueMeta(combined, 0, -1, -1);
                hbvm.setHBaseTypeFromString(type);
                String indexedV = XMLHandler.getTagValue((Node)fieldNode, (String)"indexed_vals");
                if (!Const.isEmpty((String)indexedV)) {
                    Object[] nomVals = HBaseValueMeta.stringIndexListToObjects(indexedV);
                    hbvm.setIndex(nomVals);
                    hbvm.setStorageType(2);
                }
                try {
                    this.addMappedColumn(hbvm, this.isTupleMapping());
                    continue;
                }
                catch (Exception ex) {
                    throw new KettleXMLException((Throwable)ex);
                }
            }
        }
        return true;
    }

    public boolean readRep(Repository rep, ObjectId id_step) throws KettleException {
        int nrfields;
        if (Const.isEmpty((String)rep.getStepAttributeString(id_step, 0, "key_type"))) {
            return false;
        }
        this.setMappingName(rep.getStepAttributeString(id_step, 0, "mapping_name"));
        this.setTableName(rep.getStepAttributeString(id_step, 0, "table_name"));
        String keyName = rep.getStepAttributeString(id_step, 0, "key");
        if (keyName.indexOf(44) > 0) {
            String familiesList;
            this.setTupleMapping(true);
            this.setKeyName(keyName.substring(0, keyName.indexOf(44)));
            if (keyName.indexOf(44) != keyName.length() - 1 && !Const.isEmpty((String)(familiesList = keyName.substring(keyName.indexOf(44) + 1, keyName.length())).trim())) {
                this.setTupleFamilies(familiesList);
            }
        } else {
            this.setKeyName(keyName);
        }
        String keyTypeS = rep.getStepAttributeString(id_step, 0, "key_type");
        for (KeyType k : KeyType.values()) {
            if (!k.toString().equalsIgnoreCase(keyTypeS)) continue;
            this.setKeyType(k);
            break;
        }
        if ((nrfields = rep.countNrStepAttributes(id_step, "column_family")) > 0) {
            for (int i = 0; i < nrfields; ++i) {
                String colName;
                String alias = rep.getStepAttributeString(id_step, i, "alias");
                String colFam = rep.getStepAttributeString(id_step, i, "column_family");
                if (colFam == null) {
                    colFam = "";
                }
                if ((colName = rep.getStepAttributeString(id_step, i, "column_name")) == null) {
                    colName = "";
                }
                String type = rep.getStepAttributeString(id_step, i, "type");
                String combined = colFam + "," + colName + "," + alias;
                HBaseValueMeta hbvm = new HBaseValueMeta(combined, 0, -1, -1);
                hbvm.setHBaseTypeFromString(type);
                String indexedV = rep.getStepAttributeString(id_step, i, "indexed_vals");
                if (!Const.isEmpty((String)indexedV)) {
                    Object[] nomVals = HBaseValueMeta.stringIndexListToObjects(indexedV);
                    hbvm.setIndex(nomVals);
                    hbvm.setStorageType(2);
                }
                try {
                    this.addMappedColumn(hbvm, this.isTupleMapping());
                    continue;
                }
                catch (Exception ex) {
                    throw new KettleException((Throwable)ex);
                }
            }
        }
        return true;
    }

    public String toString() {
        Set<String> aliases = this.m_mappedColumnsByAlias.keySet();
        boolean first = true;
        StringBuffer result = new StringBuffer();
        result.append("Mapping \"" + this.getMappingName() + "\" on table \"" + this.getTableName() + "\":\n\n");
        result.append("\tKEY (" + this.getKeyName() + "): " + this.getKeyType().toString());
        result.append("\n\n");
        if (aliases.size() > 0) {
            for (String alias : aliases) {
                HBaseValueMeta vm = this.m_mappedColumnsByAlias.get(alias);
                if (first) {
                    first = false;
                }
                result.append("\t\"" + alias + "\" (" + vm.getColumnFamily() + "," + vm.getColumnName() + "): ");
                if (vm.getStorageType() == 2) {
                    Object[] labels = vm.getIndex();
                    result.append("{");
                    for (int i = 0; i < labels.length; ++i) {
                        if (i == labels.length - 1) {
                            result.append(labels[i].toString().trim()).append("}\n");
                            continue;
                        }
                        result.append(labels[i].toString().trim()).append(",");
                    }
                    continue;
                }
                result.append(ValueMetaInterface.typeCodes[vm.getType()]).append("\n");
            }
        }
        return result.toString();
    }

    public static enum TupleMapping {
        KEY("KEY"),
        FAMILY("Family"),
        COLUMN("Column"),
        VALUE("Value"),
        TIMESTAMP("Timestamp");

        private final String m_stringVal;

        private TupleMapping(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    public static enum KeyType {
        STRING("String"),
        INTEGER("Integer"),
        UNSIGNED_INTEGER("UnsignedInteger"),
        LONG("Long"),
        UNSIGNED_LONG("UnsignedLong"),
        DATE("Date"),
        UNSIGNED_DATE("UnsignedDate"),
        BINARY("Binary");

        private final String m_stringVal;

        private KeyType(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

