/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.mapreduce;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarUtility {
    private static final Logger logger = LoggerFactory.getLogger(JarUtility.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getMainClassFromManifest(URL jarUrl, ClassLoader parentClassLoader) throws IOException, ClassNotFoundException {
        try (JarFile jarFile = this.getJarFile(jarUrl, parentClassLoader);){
            Manifest manifest = jarFile.getManifest();
            String className = manifest == null ? null : manifest.getMainAttributes().getValue("Main-Class");
            Class<?> clazz = this.loadClassByName(className, jarUrl, parentClassLoader);
            return clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClassByName(String className, URL jarUrl, ClassLoader parentClassLoader) throws IOException, ClassNotFoundException {
        try (JarFile jarFile = this.getJarFile(jarUrl, parentClassLoader);){
            Class<?> clazz = this.loadClassByName(className, jarUrl, parentClassLoader);
            return clazz;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> loadClassByName(String className, URL jarUrl, ClassLoader parentClassLoader) throws ClassNotFoundException {
        if (className == null) return null;
        try (URLClassLoader cl = new URLClassLoader(new URL[]{jarUrl}, parentClassLoader);){
            Class<?> clazz = cl.loadClass(className.replace("/", "."));
            return clazz;
        }
        catch (IOException e) {
            logger.debug(" Classloader was not close, possible resource leak.", (Throwable)e);
        }
        return null;
    }

    private JarFile getJarFile(URL jarUrl, ClassLoader parentClassLoader) throws IOException {
        JarFile jarFile;
        if (jarUrl == null || parentClassLoader == null) {
            throw new NullPointerException();
        }
        try {
            jarFile = new JarFile(new File(jarUrl.toURI()));
        }
        catch (URISyntaxException ex) {
            throw new IOException("Error locating jar: " + jarUrl);
        }
        catch (IOException ex) {
            throw new IOException("Error opening job jar: " + jarUrl, ex);
        }
        return jarFile;
    }

    public List<Class<?>> getClassesInJarWithMain(String jarUrl, ClassLoader parentClassloader) throws MalformedURLException {
        ArrayList mainClasses = new ArrayList();
        List<Class<?>> allClasses = JarUtility.getClassesInJar(jarUrl, parentClassloader);
        for (Class<?> clazz : allClasses) {
            try {
                Method mainMethod = clazz.getMethod("main", String[].class);
                if (!Modifier.isStatic(mainMethod.getModifiers())) continue;
                mainClasses.add(clazz);
            }
            catch (Throwable throwable) {}
        }
        return mainClasses;
    }

    public static List<Class<?>> getClassesInJar(String jarUrl, ClassLoader parentClassloader) throws MalformedURLException {
        ArrayList classes = new ArrayList();
        URL url = new URL(jarUrl);
        URL[] urls = new URL[]{url};
        try (URLClassLoader loader = new URLClassLoader(urls, parentClassloader);
             JarInputStream jarFile = new JarInputStream(new FileInputStream(new File(url.toURI())));){
            JarEntry jarEntry;
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName().substring(0, jarEntry.getName().indexOf(".class")).replace("/", "\\.");
                classes.add(loader.loadClass(className));
            }
        }
        catch (IOException e) {
            logger.debug(" Unable to read next entry form jar " + jarUrl, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.debug(" Class was not loaded ", (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.debug(" Unable to read jar  ", (Throwable)e);
        }
        return classes;
    }
}

