/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.bigdata;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.pentaho.di.bigdata.ShimDependentJobEntry;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolder;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeCategoriesOrder;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryInterface;

@PluginTypeCategoriesOrder(getNaturalCategoriesOrder={"JobCategory.Category.General", "JobCategory.Category.Mail", "JobCategory.Category.FileManagement", "JobCategory.Category.Conditions", "JobCategory.Category.Scripting", "JobCategory.Category.BulkLoading", "JobCategory.Category.BigData", "JobCategory.Category.DataQuality", "JobCategory.Category.XML", "JobCategory.Category.Utility", "JobCategory.Category.Repository", "JobCategory.Category.FileTransfer", "JobCategory.Category.FileEncryption", "JobCategory.Category.Palo", "JobCategory.Category.Experimental", "JobCategory.Category.Deprecated"}, i18nPackageClass=JobMeta.class)
@PluginMainClassType(value=JobEntryInterface.class)
@PluginAnnotationType(value=JobEntry.class)
public class ShimDependentJobEntryPluginType
extends JobEntryPluginType {
    private static final ShimDependentJobEntryPluginType instance = new ShimDependentJobEntryPluginType();
    private final Map<Set<String>, KettleURLClassLoader> classLoaderMap = new HashMap<Set<String>, KettleURLClassLoader>();

    private ShimDependentJobEntryPluginType() {
        super(ShimDependentJobEntry.class, "SHIM_DEPENDENT_JOBENTRY", "Shim Dependent Job entry");
    }

    public static ShimDependentJobEntryPluginType getInstance() {
        return instance;
    }

    public List<PluginFolderInterface> getPluginFolders() {
        return Arrays.asList(new PluginFolder(new File(ShimDependentJobEntryPluginType.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile().toURI().toString() + "plugins/", false, true){

            public FileObject[] findJarFiles(final boolean includeLibJars) throws KettleFileException {
                try {
                    FileObject folderObject = KettleVFS.getFileObject((String)this.getFolder());
                    FileObject[] fileObjects = folderObject.findFiles(new FileSelector(){

                        public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
                            FileObject fileObject = fileSelectInfo.getFile();
                            String folder = fileObject.getName().getBaseName();
                            return includeLibJars || !"lib".equals(folder);
                        }

                        public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
                            return fileSelectInfo.getFile().toString().endsWith(".jar");
                        }
                    });
                    return fileObjects;
                }
                catch (Exception e) {
                    throw new KettleFileException("Unable to list jar files in plugin folder '" + this.toString() + "'", (Throwable)e);
                }
            }
        });
    }

    public void handlePluginAnnotation(Class<?> clazz, Annotation annotation, List<String> libraries, boolean nativePluginType, URL pluginFolder) throws KettlePluginException {
        String idList = this.extractID(annotation);
        if (Const.isEmpty((String)idList)) {
            throw new KettlePluginException("No ID specified for plugin with class: " + clazz.getName());
        }
        String[] ids = idList.split(",");
        super.handlePluginAnnotation(clazz, annotation, libraries, nativePluginType, pluginFolder);
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(ShimDependentJobEntryPluginType.class, ids[0]);
        URL[] urls = new URL[libraries.size()];
        for (int i = 0; i < libraries.size(); ++i) {
            File jarfile = new File(libraries.get(i));
            try {
                urls[i] = new URL(URLDecoder.decode(jarfile.toURI().toURL().toString(), "UTF-8"));
                continue;
            }
            catch (Exception e) {
                throw new KettlePluginException((Throwable)e);
            }
        }
        HashSet<String> librarySet = new HashSet<String>(libraries);
        KettleURLClassLoader classloader = this.classLoaderMap.get(librarySet);
    }

    protected void registerNatives() throws KettlePluginException {
    }

    protected String extractCategory(Annotation annotation) {
        return ((ShimDependentJobEntry)annotation).categoryDescription();
    }

    protected String extractDesc(Annotation annotation) {
        return ((ShimDependentJobEntry)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((ShimDependentJobEntry)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((ShimDependentJobEntry)annotation).name();
    }

    protected String extractImageFile(Annotation annotation) {
        return ((ShimDependentJobEntry)annotation).image();
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return ((ShimDependentJobEntry)annotation).i18nPackageName();
    }

    protected String extractDocumentationUrl(Annotation annotation) {
        return ((ShimDependentJobEntry)annotation).documentationUrl();
    }

    protected String extractCasesUrl(Annotation annotation) {
        return ((ShimDependentJobEntry)annotation).casesUrl();
    }

    protected String extractForumUrl(Annotation annotation) {
        return ((ShimDependentJobEntry)annotation).forumUrl();
    }
}

