/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.util.AsyncSink;

public class NullAsyncSink
extends AsyncSink {
    public static final Log LOG = LogFactory.getLog((String)NullAsyncSink.class.getName());
    private Thread child;

    @Override
    public void processStream(InputStream is) {
        this.child = new IgnoringThread(is);
        this.child.start();
    }

    @Override
    public int join() throws InterruptedException {
        this.child.join();
        return 0;
    }

    private static class IgnoringThread
    extends Thread {
        private InputStream stream;

        IgnoringThread(InputStream is) {
            this.stream = is;
        }

        @Override
        public void run() {
            InputStreamReader isr = new InputStreamReader(this.stream);
            BufferedReader r = new BufferedReader(isr);
            try {
                String line;
                while (null != (line = r.readLine())) {
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)("IOException reading from (ignored) stream: " + ioe.toString()));
            }
            try {
                r.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Error closing stream in NullAsyncSink: " + ioe.toString()));
            }
        }
    }
}

