/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.orm.ClassWriter;
import org.apache.sqoop.orm.TableClassName;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class AvroSchemaGenerator {
    public static final Log LOG = LogFactory.getLog((String)AvroSchemaGenerator.class.getName());
    public static final int MAX_PRECISION = 38;
    public static final int[] PRECISION_TO_BYTE_COUNT = new int[38];
    private final SqoopOptions options;
    private final ConnManager connManager;
    private final String tableName;
    private final String DEFAULT_SCHEMA_NAME = "AutoGeneratedSchema";

    public AvroSchemaGenerator(SqoopOptions opts, ConnManager connMgr, String table) {
        this.options = opts;
        this.connManager = connMgr;
        this.tableName = table;
    }

    public Schema generate() throws IOException {
        return this.generate(null);
    }

    public Schema generate(String schemaNameOverride) throws IOException {
        String avroTableName;
        ClassWriter classWriter = new ClassWriter(this.options, this.connManager, this.tableName, null);
        Map<String, List<Integer>> columnInfo = classWriter.getColumnInfo();
        Map<String, Integer> columnTypes = classWriter.getColumnTypes();
        String[] columnNames = classWriter.getColumnNames(columnTypes);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (String columnName : columnNames) {
            String cleanedCol = AvroUtil.toAvroIdentifier(ClassWriter.toJavaIdentifier(columnName));
            List<Integer> columnInfoList = columnInfo.get(columnName);
            int sqlType = columnInfoList.get(0);
            Integer precision = columnInfoList.get(1);
            Integer scale = columnInfoList.get(2);
            Schema avroSchema = this.toAvroSchema(sqlType, columnName, precision, scale);
            Schema.Field field = new Schema.Field(cleanedCol, avroSchema, null, (JsonNode)NullNode.getInstance());
            field.addProp("columnName", columnName);
            field.addProp("sqlType", Integer.toString(sqlType));
            fields.add(field);
        }
        TableClassName tableClassName = new TableClassName(this.options);
        String shortClassName = this.tableName == null ? "AutoGeneratedSchema" : tableClassName.getShortClassForTable(this.tableName);
        String string = avroTableName = this.tableName == null ? "QueryResult" : this.tableName;
        String avroName = schemaNameOverride != null ? schemaNameOverride : (shortClassName == null ? avroTableName : shortClassName);
        String avroNamespace = tableClassName.getPackageForTable();
        String doc = "Sqoop import of " + avroTableName;
        Schema schema = Schema.createRecord((String)avroName, (String)doc, (String)avroNamespace, (boolean)false);
        schema.setFields(fields);
        schema.addProp("tableName", avroTableName);
        return schema;
    }

    public Schema toAvroSchema(int sqlType, String columnName, Integer precision, Integer scale) {
        ArrayList<Schema> childSchemas = new ArrayList<Schema>();
        childSchemas.add(Schema.create((Schema.Type)Schema.Type.NULL));
        if (this.options.getConf().getBoolean("sqoop.avro.logical_types.decimal.enable", false) && AvroSchemaGenerator.isLogicalType(sqlType)) {
            childSchemas.add(this.toAvroLogicalType(columnName, sqlType, precision, scale).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES)));
        } else {
            childSchemas.add(Schema.create((Schema.Type)this.toAvroType(columnName, sqlType)));
        }
        return Schema.createUnion(childSchemas);
    }

    public Schema toAvroSchema(int sqlType) {
        return this.toAvroSchema(sqlType, null, null, null);
    }

    private Schema.Type toAvroType(String columnName, int sqlType) {
        Properties mapping = this.options.getMapColumnJava();
        if (mapping.containsKey(columnName)) {
            String type = mapping.getProperty(columnName);
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Overriding type of column " + columnName + " to " + type));
            }
            if (type.equalsIgnoreCase("INTEGER")) {
                return Schema.Type.INT;
            }
            if (type.equalsIgnoreCase("LONG")) {
                return Schema.Type.LONG;
            }
            if (type.equalsIgnoreCase("BOOLEAN")) {
                return Schema.Type.BOOLEAN;
            }
            if (type.equalsIgnoreCase("FLOAT")) {
                return Schema.Type.FLOAT;
            }
            if (type.equalsIgnoreCase("DOUBLE")) {
                return Schema.Type.DOUBLE;
            }
            if (type.equalsIgnoreCase("STRING")) {
                return Schema.Type.STRING;
            }
            if (type.equalsIgnoreCase("BYTES")) {
                return Schema.Type.BYTES;
            }
            throw new IllegalArgumentException("Cannot convert to AVRO type " + type);
        }
        return this.connManager.toAvroType(this.tableName, columnName, sqlType);
    }

    private LogicalType toAvroLogicalType(String columnName, int sqlType, Integer precision, Integer scale) {
        return this.connManager.toAvroLogicalType(this.tableName, columnName, sqlType, precision, scale);
    }

    private static boolean isLogicalType(int sqlType) {
        switch (sqlType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    static {
        for (int prec = 1; prec <= 38; ++prec) {
            AvroSchemaGenerator.PRECISION_TO_BYTE_COUNT[prec - 1] = (int)Math.ceil((Math.log(Math.pow(10.0, prec) - 1.0) / Math.log(2.0) + 1.0) / 8.0);
        }
    }
}

