/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.metastore;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.metastore.JobStorage;

public class JobStorageFactory {
    private Configuration conf;
    public static final String AVAILABLE_STORAGES_KEY = "sqoop.job.storage.implementations";
    private static final String DEFAULT_AVAILABLE_STORAGES = "org.apache.sqoop.metastore.GenericJobStorage,org.apache.sqoop.metastore.AutoGenericJobStorage";

    public JobStorageFactory(Configuration config) {
        this.conf = config;
        if (this.conf.get(AVAILABLE_STORAGES_KEY) == null) {
            this.conf.set(AVAILABLE_STORAGES_KEY, DEFAULT_AVAILABLE_STORAGES);
        }
    }

    public JobStorage getJobStorage(Map<String, String> descriptor) {
        List<JobStorage> storages = ConfigurationHelper.getInstances(this.conf, AVAILABLE_STORAGES_KEY, JobStorage.class);
        for (JobStorage stor : storages) {
            if (!stor.canAccept(descriptor)) continue;
            return stor;
        }
        return null;
    }
}

