/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.postgresql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.lib.DelimiterSet;
import org.apache.sqoop.mapreduce.AutoProgressMapper;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.util.LoggingUtils;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyManager;

public class PostgreSQLCopyExportMapper
extends AutoProgressMapper<LongWritable, Writable, NullWritable, NullWritable> {
    public static final Log LOG = LogFactory.getLog((String)PostgreSQLCopyExportMapper.class.getName());
    private Configuration conf;
    private DBConfiguration dbConf;
    private Connection conn = null;
    private CopyIn copyin = null;
    private StringBuilder line = new StringBuilder();
    private DelimiterSet delimiters = new DelimiterSet(',', '\n', '\u0000', '\u0000', false);

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.conf = context.getConfiguration();
        this.dbConf = new DBConfiguration(this.conf);
        CopyManager cm = null;
        try {
            this.conn = this.dbConf.getConnection();
            cm = ((PGConnection)this.conn).getCopyAPI();
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Unable to load JDBC driver class", (Throwable)ex);
            throw new IOException(ex);
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to get CopyIn", ex);
            throw new IOException(ex);
        }
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("COPY ");
            sql.append(this.dbConf.getOutputTableName());
            sql.append(" FROM STDIN WITH (");
            sql.append(" ENCODING 'UTF-8' ");
            sql.append(", FORMAT csv ");
            sql.append(", DELIMITER ");
            sql.append("'");
            sql.append(this.conf.get("postgresql.input.field.delim", ","));
            sql.append("'");
            sql.append(", QUOTE ");
            sql.append("'");
            sql.append(this.conf.get("postgresql.input.enclosedby", "\""));
            sql.append("'");
            sql.append(", ESCAPE ");
            sql.append("'");
            sql.append(this.conf.get("postgresql.input.escapedby", "\""));
            sql.append("'");
            if (this.conf.get("postgresql.null.string") != null) {
                sql.append(", NULL ");
                sql.append("'");
                sql.append(this.conf.get("postgresql.null.string"));
                sql.append("'");
            }
            sql.append(")");
            LOG.debug((Object)("Starting export with copy: " + sql));
            this.copyin = cm.copyIn(sql.toString());
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to get CopyIn", ex);
            this.close();
            throw new IOException(ex);
        }
    }

    public void map(LongWritable key, Writable value, Mapper.Context context) throws IOException, InterruptedException {
        this.line.setLength(0);
        this.line.append(value.toString());
        if (value instanceof Text) {
            this.line.append(System.getProperty("line.separator"));
        }
        try {
            byte[] data = this.line.toString().getBytes("UTF-8");
            this.copyin.writeToCopy(data, 0, data.length);
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to execute copy", ex);
            this.close();
            throw new IOException(ex);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.copyin.endCopy();
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to finalize copy", ex);
            throw new IOException(ex);
        }
        this.close();
    }

    void close() throws IOException {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Unable to close connection", ex);
                throw new IOException(ex);
            }
        }
    }
}

