/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.parquet.kite;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.sqoop.avro.AvroSchemaMismatchException;
import org.apache.sqoop.hive.HiveConfig;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;
import org.kitesdk.data.View;
import org.kitesdk.data.mapreduce.DatasetKeyOutputFormat;
import org.kitesdk.data.spi.SchemaValidationUtil;

public final class KiteParquetUtils {
    public static final Log LOG = LogFactory.getLog((String)KiteParquetUtils.class.getName());
    public static final String HIVE_METASTORE_CLIENT_CLASS = "org.apache.hadoop.hive.metastore.HiveMetaStoreClient";
    public static final String HIVE_METASTORE_SASL_ENABLED = "hive.metastore.sasl.enabled";
    public static final String HIVE_METASTORE_TOKEN_ALIAS = "HCat Token";
    public static final String INCOMPATIBLE_AVRO_SCHEMA_MSG = "Target dataset was created with an incompatible Avro schema. ";
    public static final String HIVE_INCOMPATIBLE_AVRO_SCHEMA_MSG = "You tried to import to an already existing Hive table in Parquet format. Sqoop maps date/timestamp SQL types to int/bigint Hive types during Hive Parquet import but it is possible that date/timestamp types were mapped to strings during table creation. Consider using Sqoop option --map-column-java resolve the mismatch (e.g. --map-column-java date_field1=String,timestamp_field1=String).";
    private static final String HIVE_URI_PREFIX = "dataset:hive";

    private KiteParquetUtils() {
    }

    public static CompressionType getCompressionType(Configuration conf) {
        CompressionType defaults = Formats.PARQUET.getDefaultCompressionType();
        String codec = conf.get("parquetjob.output.codec", defaults.getName());
        try {
            return CompressionType.forName((String)codec);
        }
        catch (IllegalArgumentException ex) {
            LOG.warn((Object)String.format("Unsupported compression type '%s'. Fallback to '%s'.", codec, defaults));
            return defaults;
        }
    }

    public static void configureImportJob(JobConf conf, Schema schema, String uri, WriteMode writeMode) throws IOException {
        Dataset dataset;
        Configuration hiveConf;
        if (KiteParquetUtils.isHiveImport(uri) && KiteParquetUtils.isSecureMetastore(hiveConf = HiveConfig.getHiveConf((Configuration)conf))) {
            HiveConfig.addHiveConfigs(hiveConf, (Configuration)conf);
            if (conf.getCredentials().getToken(new Text(HIVE_METASTORE_TOKEN_ALIAS)) == null) {
                KiteParquetUtils.addHiveDelegationToken(conf);
            }
        }
        if (Datasets.exists((String)uri)) {
            if (WriteMode.DEFAULT.equals((Object)writeMode)) {
                throw new IOException("Destination exists! " + uri);
            }
            dataset = (Dataset)Datasets.load((String)uri);
            Schema writtenWith = dataset.getDescriptor().getSchema();
            if (!SchemaValidationUtil.canRead((Schema)writtenWith, (Schema)schema)) {
                String exceptionMessage = KiteParquetUtils.buildAvroSchemaMismatchMessage(KiteParquetUtils.isHiveImport(uri));
                throw new AvroSchemaMismatchException(exceptionMessage, writtenWith, schema);
            }
        } else {
            dataset = KiteParquetUtils.createDataset(schema, KiteParquetUtils.getCompressionType((Configuration)conf), uri);
        }
        conf.set("parquetjob.avro.schema", schema.toString());
        DatasetKeyOutputFormat.ConfigBuilder builder = DatasetKeyOutputFormat.configure((Configuration)conf);
        if (WriteMode.OVERWRITE.equals((Object)writeMode)) {
            builder.overwrite((View)dataset);
        } else if (WriteMode.APPEND.equals((Object)writeMode)) {
            builder.appendTo((View)dataset);
        } else {
            builder.writeTo((View)dataset);
        }
    }

    private static boolean isHiveImport(String importUri) {
        return importUri.startsWith(HIVE_URI_PREFIX);
    }

    public static Dataset createDataset(Schema schema, CompressionType compressionType, String uri) {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).format(Formats.PARQUET).compressionType(compressionType).build();
        return (Dataset)Datasets.create((String)uri, (DatasetDescriptor)descriptor, GenericRecord.class);
    }

    private static boolean isSecureMetastore(Configuration conf) {
        return conf != null && conf.getBoolean(HIVE_METASTORE_SASL_ENABLED, false);
    }

    private static void addHiveDelegationToken(JobConf conf) {
        Class<?> HiveConfClass;
        Class<?> HiveMetaStoreClientClass;
        try {
            HiveMetaStoreClientClass = Class.forName(HIVE_METASTORE_CLIENT_CLASS);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Could not load org.apache.hadoop.hive.metastore.HiveMetaStoreClient when adding hive delegation token. Make sure HIVE_CONF_DIR is set correctly.", (Throwable)ex);
            throw new RuntimeException("Couldn't fetch delegation token.", ex);
        }
        try {
            HiveConfClass = Class.forName("org.apache.hadoop.hive.conf.HiveConf");
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Could not load org.apache.hadoop.hive.conf.HiveConf when adding hive delegation token. Make sure HIVE_CONF_DIR is set correctly.", (Throwable)ex);
            throw new RuntimeException("Couldn't fetch delegation token.", ex);
        }
        try {
            Object client = HiveMetaStoreClientClass.getConstructor(HiveConfClass).newInstance(HiveConfClass.getConstructor(Configuration.class, Class.class).newInstance(conf, Configuration.class));
            Method getDelegationTokenMethod = HiveMetaStoreClientClass.getMethod("getDelegationToken", String.class);
            Object tokenStringForm = getDelegationTokenMethod.invoke(client, UserGroupInformation.getLoginUser().getShortUserName());
            Token metastoreToken = new Token();
            metastoreToken.decodeFromUrlString(tokenStringForm.toString());
            conf.getCredentials().addToken(new Text(HIVE_METASTORE_TOKEN_ALIAS), metastoreToken);
            LOG.debug((Object)("Successfully fetched hive metastore delegation token. " + metastoreToken));
        }
        catch (Exception ex) {
            LOG.error((Object)"Couldn't fetch delegation token.", (Throwable)ex);
            throw new RuntimeException("Couldn't fetch delegation token.", ex);
        }
    }

    private static String buildAvroSchemaMismatchMessage(boolean hiveImport) {
        String exceptionMessage = INCOMPATIBLE_AVRO_SCHEMA_MSG;
        if (hiveImport) {
            exceptionMessage = exceptionMessage + HIVE_INCOMPATIBLE_AVRO_SCHEMA_MSG;
        }
        return exceptionMessage;
    }

    public static enum WriteMode {
        DEFAULT,
        APPEND,
        OVERWRITE;

    }
}

