/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.parquet.kite;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.parquet.avro.AvroParquetInputFormat;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.schema.MessageType;
import org.apache.sqoop.mapreduce.MergeParquetMapper;
import org.apache.sqoop.mapreduce.parquet.ParquetMergeJobConfigurator;
import org.apache.sqoop.mapreduce.parquet.kite.KiteMergeParquetReducer;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;
import org.kitesdk.data.View;
import org.kitesdk.data.mapreduce.DatasetKeyOutputFormat;

public class KiteParquetMergeJobConfigurator
implements ParquetMergeJobConfigurator {
    public static final Log LOG = LogFactory.getLog((String)KiteParquetMergeJobConfigurator.class.getName());

    @Override
    public void configureParquetMergeJob(Configuration conf, Job job, Path oldPath, Path newPath, Path finalPath) throws IOException {
        try {
            FileSystem fileSystem = finalPath.getFileSystem(conf);
            LOG.info((Object)"Trying to merge parquet files");
            job.setOutputKeyClass(GenericRecord.class);
            job.setMapperClass(MergeParquetMapper.class);
            job.setReducerClass(KiteMergeParquetReducer.class);
            job.setOutputValueClass(NullWritable.class);
            ArrayList footers = new ArrayList();
            FileStatus oldPathfileStatus = fileSystem.getFileStatus(oldPath);
            FileStatus newPathfileStatus = fileSystem.getFileStatus(oldPath);
            footers.addAll(ParquetFileReader.readFooters((Configuration)job.getConfiguration(), (FileStatus)oldPathfileStatus, (boolean)true));
            footers.addAll(ParquetFileReader.readFooters((Configuration)job.getConfiguration(), (FileStatus)newPathfileStatus, (boolean)true));
            MessageType schema = ((Footer)footers.get(0)).getParquetMetadata().getFileMetaData().getSchema();
            AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter();
            Schema avroSchema = avroSchemaConverter.convert(schema);
            if (!fileSystem.exists(finalPath)) {
                Dataset dataset = KiteParquetMergeJobConfigurator.createDataset(avroSchema, "dataset:" + finalPath);
                DatasetKeyOutputFormat.configure((Job)job).overwrite((View)dataset);
            } else {
                DatasetKeyOutputFormat.configure((Job)job).overwrite(new URI("dataset:" + finalPath));
            }
            job.setInputFormatClass(AvroParquetInputFormat.class);
            AvroParquetInputFormat.setAvroReadSchema((Job)job, (Schema)avroSchema);
            conf.set("parquetjob.avro.schema", avroSchema.toString());
            Class<DatasetKeyOutputFormat> outClass = DatasetKeyOutputFormat.class;
            job.setOutputFormatClass(outClass);
        }
        catch (Exception cnfe) {
            throw new IOException(cnfe);
        }
    }

    public static Dataset createDataset(Schema schema, String uri) {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).format(Formats.PARQUET).build();
        return (Dataset)Datasets.create((String)uri, (DatasetDescriptor)descriptor, GenericRecord.class);
    }
}

