/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.parquet.kite;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.lib.LargeObjectLoader;
import org.apache.sqoop.mapreduce.ParquetImportMapper;

public class KiteParquetImportMapper
extends ParquetImportMapper<GenericRecord, Void> {
    @Override
    protected LargeObjectLoader createLobLoader(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        Path workPath = new Path(conf.get("sqoop.kite.lob.extern.dir", "/tmp/sqoop-parquet-" + context.getTaskAttemptID()));
        return new LargeObjectLoader(conf, workPath);
    }

    @Override
    protected Schema getAvroSchema(Configuration configuration) {
        String schemaString = configuration.get("parquetjob.avro.schema");
        return AvroUtil.parseAvroSchema(schemaString);
    }

    @Override
    protected void write(Mapper.Context context, GenericRecord record) throws IOException, InterruptedException {
        context.write((Object)record, null);
    }
}

