/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.parquet.kite;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.mapreduce.parquet.ParquetImportJobConfigurator;
import org.apache.sqoop.mapreduce.parquet.kite.KiteParquetImportMapper;
import org.apache.sqoop.mapreduce.parquet.kite.KiteParquetUtils;
import org.apache.sqoop.util.FileSystemUtil;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.mapreduce.DatasetKeyOutputFormat;

public class KiteParquetImportJobConfigurator
implements ParquetImportJobConfigurator {
    public static final Log LOG = LogFactory.getLog((String)KiteParquetImportJobConfigurator.class.getName());

    @Override
    public void configureMapper(Job job, Schema schema, SqoopOptions options, String tableName, Path destination) throws IOException {
        KiteParquetUtils.WriteMode writeMode;
        JobConf conf = (JobConf)job.getConfiguration();
        String uri = this.getKiteUri((Configuration)conf, options, tableName, destination);
        if (options.doHiveImport()) {
            if (options.doOverwriteHiveTable()) {
                writeMode = KiteParquetUtils.WriteMode.OVERWRITE;
            } else {
                writeMode = KiteParquetUtils.WriteMode.APPEND;
                if (Datasets.exists((String)uri)) {
                    LOG.warn((Object)("Target Hive table '" + tableName + "' exists! Sqoop will append data into the existing Hive table. Consider using --hive-overwrite, if you do NOT intend to do appending."));
                }
            }
        } else {
            writeMode = KiteParquetUtils.WriteMode.DEFAULT;
        }
        KiteParquetUtils.configureImportJob(conf, schema, uri, writeMode);
    }

    @Override
    public Class<? extends Mapper> getMapperClass() {
        return KiteParquetImportMapper.class;
    }

    @Override
    public Class<? extends OutputFormat> getOutputFormatClass() {
        return DatasetKeyOutputFormat.class;
    }

    @Override
    public boolean isHiveImportNeeded() {
        return false;
    }

    private String getKiteUri(Configuration conf, SqoopOptions options, String tableName, Path destination) throws IOException {
        if (options.doHiveImport()) {
            String hiveDatabase = options.getHiveDatabaseName() == null ? "default" : options.getHiveDatabaseName();
            String hiveTable = options.getHiveTableName() == null ? tableName : options.getHiveTableName();
            return String.format("dataset:hive:/%s/%s", hiveDatabase, hiveTable);
        }
        return "dataset:" + FileSystemUtil.makeQualified(destination, conf);
    }
}

