/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.parquet.hadoop;

import java.io.IOException;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.parquet.avro.AvroParquetInputFormat;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.mapreduce.MergeParquetMapper;
import org.apache.sqoop.mapreduce.parquet.ParquetMergeJobConfigurator;
import org.apache.sqoop.mapreduce.parquet.hadoop.HadoopMergeParquetReducer;
import org.apache.sqoop.mapreduce.parquet.hadoop.HadoopParquetExportJobConfigurator;
import org.apache.sqoop.mapreduce.parquet.hadoop.HadoopParquetImportJobConfigurator;

public class HadoopParquetMergeJobConfigurator
implements ParquetMergeJobConfigurator {
    public static final Log LOG = LogFactory.getLog((String)HadoopParquetMergeJobConfigurator.class.getName());
    private final HadoopParquetImportJobConfigurator importJobConfigurator;
    private final HadoopParquetExportJobConfigurator exportJobConfigurator;

    public HadoopParquetMergeJobConfigurator(HadoopParquetImportJobConfigurator importJobConfigurator, HadoopParquetExportJobConfigurator exportJobConfigurator) {
        this.importJobConfigurator = importJobConfigurator;
        this.exportJobConfigurator = exportJobConfigurator;
    }

    public HadoopParquetMergeJobConfigurator() {
        this(new HadoopParquetImportJobConfigurator(), new HadoopParquetExportJobConfigurator());
    }

    @Override
    public void configureParquetMergeJob(Configuration conf, Job job, Path oldPath, Path newPath, Path finalPath) throws IOException {
        try {
            LOG.info((Object)"Trying to merge parquet files");
            job.setOutputKeyClass(Void.class);
            job.setMapperClass(MergeParquetMapper.class);
            job.setReducerClass(HadoopMergeParquetReducer.class);
            job.setOutputValueClass(GenericRecord.class);
            Schema avroSchema = this.loadAvroSchema(conf, oldPath);
            this.validateNewPathAvroSchema(AvroUtil.getAvroSchemaFromParquetFile(newPath, conf), avroSchema);
            job.setInputFormatClass(this.exportJobConfigurator.getInputFormatClass());
            AvroParquetInputFormat.setAvroReadSchema((Job)job, (Schema)avroSchema);
            conf.set("parquetjob.avro.schema", avroSchema.toString());
            this.importJobConfigurator.configureAvroSchema(job, avroSchema);
            this.importJobConfigurator.configureOutputCodec(job);
            job.setOutputFormatClass(this.importJobConfigurator.getOutputFormatClass());
        }
        catch (Exception cnfe) {
            throw new IOException(cnfe);
        }
    }

    private Schema loadAvroSchema(Configuration conf, Path path) throws IOException {
        Schema avroSchema = AvroUtil.getAvroSchemaFromParquetFile(path, conf);
        if (avroSchema == null) {
            throw new RuntimeException("Could not load Avro schema from path: " + path);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Avro schema loaded: " + avroSchema));
        }
        return avroSchema;
    }

    private void validateNewPathAvroSchema(Schema newPathAvroSchema, Schema avroSchema) {
        if (newPathAvroSchema == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Validation Avro schema %s against %s", newPathAvroSchema.toString(), avroSchema.toString()));
        }
        SchemaValidator schemaValidator = new SchemaValidatorBuilder().mutualReadStrategy().validateAll();
        try {
            schemaValidator.validate(newPathAvroSchema, Collections.singleton(avroSchema));
        }
        catch (SchemaValidationException e) {
            throw new RuntimeException("Cannot merge files, the Avro schemas are not compatible.", e);
        }
    }
}

