/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.netezza;

import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.ImportJobBase;
import org.apache.sqoop.mapreduce.RawKeyTextOutputFormat;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaExternalTableHCatImportMapper;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaExternalTableTextImportMapper;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;
import org.apache.sqoop.mapreduce.netezza.NetezzaExternalTableInputFormat;

public class NetezzaExternalTableImportJob
extends ImportJobBase {
    public NetezzaExternalTableImportJob(SqoopOptions opts, ImportJobContext context) {
        super(opts, NetezzaExternalTableTextImportMapper.class, NetezzaExternalTableInputFormat.class, RawKeyTextOutputFormat.class, context);
    }

    @Override
    protected void propagateOptionsToJob(Job job) {
        Configuration conf = job.getConfiguration();
        String nullValue = this.options.getNullStringValue();
        if (nullValue != null) {
            conf.set("netezza.exttable.null.value", StringEscapeUtils.unescapeJava((String)nullValue));
        }
        conf.setInt("sqoop.output.field.delim", (int)this.options.getOutputFieldDelim());
        conf.setInt("sqoop.output.record.delim", (int)this.options.getOutputRecordDelim());
        conf.setInt("sqoop.output.enclosed.by", (int)this.options.getOutputEnclosedBy());
        char escapeChar = this.options.getOutputEscapedBy();
        if (escapeChar > '\u0000') {
            if (escapeChar != '\\') {
                LOG.info((Object)"Setting escaped char to \\ for Netezza external table import");
            }
            conf.setInt("sqoop.output.escaped.by", 92);
        }
        conf.setBoolean("sqoop.output.enclose.required", this.options.isOutputEncloseRequired());
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
        ConnManager mgr = this.getContext().getConnManager();
        String username = this.options.getUsername();
        if (null == username || username.length() == 0) {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString());
        } else {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword());
        }
        String[] colNames = this.options.getColumns();
        if (null == colNames) {
            colNames = mgr.getColumnNames(tableName);
        }
        String[] sqlColNames = null;
        if (null != colNames) {
            sqlColNames = new String[colNames.length];
            for (int i = 0; i < colNames.length; ++i) {
                sqlColNames[i] = mgr.escapeColName(colNames[i]);
            }
        }
        String whereClause = this.options.getWhereClause();
        DataDrivenDBInputFormat.setInput(job, DBWritable.class, tableName, whereClause, mgr.escapeColName(splitByCol), sqlColNames);
        LOG.debug((Object)("Using InputFormat: " + this.inputFormatClass));
        job.setInputFormatClass(this.getInputFormatClass());
        if (this.isHCatJob) {
            LOG.debug((Object)("Using table class: " + tableClassName));
            job.getConfiguration().set(ConfigurationHelper.getDbInputClassProperty(), tableClassName);
        }
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        super.configureMapper(job, tableName, tableClassName);
        job.setMapperClass(this.getMapperClass());
        if (this.isHCatJob) {
            LOG.info((Object)"Configuring mapper for HCatalog import job");
            job.setOutputKeyClass(LongWritable.class);
            job.setOutputValueClass(SqoopHCatUtilities.getImportValueClass());
            return;
        }
        job.setOutputKeyClass(String.class);
        job.setOutputValueClass(NullWritable.class);
    }

    @Override
    protected Class<? extends OutputFormat> getOutputFormatClass() throws ClassNotFoundException {
        if (this.isHCatJob) {
            return SqoopHCatUtilities.getOutputFormatClass();
        }
        return RawKeyTextOutputFormat.class;
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        if (this.isHCatJob) {
            return NetezzaExternalTableHCatImportMapper.class;
        }
        return NetezzaExternalTableTextImportMapper.class;
    }
}

