/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;

public class MainframeFTPFileEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static String REGEX = "^\\S+\\s+(\\S+)\\s+.*?\\s+(\\S+)$";
    private static String NON_TAPE_REGEX = "^\\S+\\s+(\\S+)\\s+.*?(\\d+)\\s+(\\S+)\\s+(\\S+)$";
    static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd HH:mm";
    private static String MIGRATED_REGEX = "^(Migrated)\\s+(\\S+)$";
    static final String DEFAULT_RECENT_DATE_FORMAT = "MMM d HH:mm";
    private static String tapeUnitString = "Tape";
    private static String unitHeaderString = "Unit";
    private static String dsNameHeaderString = "Dsname";
    private static String dsOrgPDSString = "PO";
    private static String dsOrgPDSExtendedString = "PO-E";
    private static String dsOrgSeqString = "PS";
    private static Pattern nonTapePattern = Pattern.compile(NON_TAPE_REGEX);
    private static final String MIGRATED_STRING = "Migrated";
    private static Pattern migratedPattern = Pattern.compile(MIGRATED_REGEX);
    private static final Log LOG = LogFactory.getLog((String)MainframeFTPFileEntryParser.class.getName());

    public MainframeFTPFileEntryParser() {
        super(REGEX);
        LOG.info((Object)"MainframeFTPFileEntryParser constructor");
    }

    public MainframeFTPFileEntryParser(String regex) {
        super(REGEX);
    }

    public FTPFile parseFTPEntry(String entry) {
        LOG.info((Object)("parseFTPEntry: " + entry));
        if (this.matches(entry)) {
            String unit = this.group(1);
            String dsName = this.group(2);
            LOG.info((Object)("parseFTPEntry match: " + this.group(1) + " " + this.group(2)));
            if (unit.equals(unitHeaderString) && dsName.equals(dsNameHeaderString)) {
                return null;
            }
            FTPFile file = new FTPFile();
            file.setRawListing(entry);
            file.setName(dsName);
            if (!unit.equals("Tape")) {
                Matcher m = nonTapePattern.matcher(entry);
                if (m.matches()) {
                    String size = m.group(2);
                    String dsOrg = m.group(3);
                    file.setSize(Long.parseLong(size));
                    LOG.info((Object)String.format("Non tape match: %s, %s, %s", file.getName(), file.getSize(), dsOrg));
                    if (dsOrg.equals(dsOrgPDSString) || dsOrg.equals(dsOrgPDSExtendedString)) {
                        file.setType(1);
                    }
                    if (dsOrg.equals(dsOrgSeqString)) {
                        file.setType(0);
                    }
                }
            } else {
                LOG.info((Object)String.format("Tape match: %s, %s", file.getName(), unit));
                file.setType(0);
            }
            return file;
        }
        return this.parseMigratedEntry(entry);
    }

    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("MVS", DEFAULT_DATE_FORMAT, null, null, null, null);
    }

    private FTPFile parseMigratedEntry(String entry) {
        Matcher m = migratedPattern.matcher(entry);
        if (m.matches()) {
            String volume = m.group(1);
            String dsName = m.group(2);
            FTPFile file = new FTPFile();
            if (MIGRATED_STRING.equals(volume)) {
                file.setRawListing(entry);
                file.setType(0);
                file.setName(dsName);
                LOG.info((Object)String.format("Migrated Dataset found: %s, %s", volume, dsName));
                return file;
            }
        }
        return null;
    }
}

