/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.mainframe.MainframeConfiguration;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetPath;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetRecordReader;
import org.apache.sqoop.util.MainframeFTPClientUtils;

public class MainframeDatasetFTPRecordReader<T extends SqoopRecord>
extends MainframeDatasetRecordReader<T> {
    private FTPClient ftp = null;
    private BufferedReader datasetReader = null;
    private BufferedInputStream inputStream = null;
    private static final Log LOG = LogFactory.getLog((String)MainframeDatasetFTPRecordReader.class.getName());

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        super.initialize(inputSplit, taskAttemptContext);
        Configuration conf = this.getConfiguration();
        this.ftp = MainframeFTPClientUtils.getFTPConnection(conf);
        this.initialize(this.ftp, conf);
    }

    public void initialize(FTPClient ftpClient, Configuration conf) throws IOException {
        this.ftp = ftpClient;
        if (this.ftp != null) {
            String dsName = conf.get("mapreduce.mainframe.input.dataset.name");
            String dsType = conf.get("mapreduce.mainframe.input.dataset.type");
            MainframeDatasetPath p = null;
            try {
                p = new MainframeDatasetPath(dsName, conf);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
                LOG.error((Object)"MainframeDatasetPath helper class incorrectly initialised");
                e.printStackTrace();
            }
            if (dsType != null && p != null) {
                dsName = p.getMainframeDatasetFolder();
            }
            this.ftp.changeWorkingDirectory("'" + dsName + "'");
        }
    }

    public void close() throws IOException {
        if (this.datasetReader != null) {
            this.datasetReader.close();
        }
        if (this.ftp != null) {
            MainframeFTPClientUtils.closeFTPConnection(this.ftp);
        }
    }

    @Override
    protected boolean getNextRecord(T sqoopRecord) throws IOException {
        String line = null;
        Configuration conf = this.getConfiguration();
        if ("binary".equals(conf.get("mainframe.ftp.transfermode"))) {
            return this.getNextBinaryRecord(sqoopRecord);
        }
        try {
            do {
                if (this.datasetReader == null) {
                    String dsName = this.getNextDataset();
                    if (dsName == null) break;
                    this.datasetReader = new BufferedReader(new InputStreamReader(this.ftp.retrieveFileStream(dsName)));
                }
                if ((line = this.datasetReader.readLine()) != null) continue;
                this.datasetReader.close();
                this.datasetReader = null;
                if (!this.ftp.completePendingCommand()) {
                    throw new IOException("Failed to complete ftp command.");
                }
                LOG.info((Object)"Data transfer completed.");
            } while (line == null);
        }
        catch (IOException ioe) {
            throw new IOException("IOException during data transfer: " + ioe.toString());
        }
        if (line != null) {
            this.convertToSqoopRecord(line, (SqoopRecord)sqoopRecord);
            return true;
        }
        return false;
    }

    protected boolean getNextBinaryRecord(T sqoopRecord) throws IOException {
        Configuration conf = this.getConfiguration();
        int BUFFER_SIZE = MainframeConfiguration.MAINFRAME_FTP_TRANSFER_BINARY_DEFAULT_BUFFER_SIZE;
        if (conf != null) {
            BUFFER_SIZE = conf.getInt("mainframe.ftp.buffersize", MainframeConfiguration.MAINFRAME_FTP_TRANSFER_BINARY_DEFAULT_BUFFER_SIZE.intValue());
        }
        byte[] buf = new byte[BUFFER_SIZE];
        int bytesRead = -1;
        int cumulativeBytesRead = 0;
        try {
            Boolean streamInited = this.initInputStream(BUFFER_SIZE);
            if (!streamInited.booleanValue()) {
                LOG.info((Object)"No more datasets to process.");
                return false;
            }
            do {
                if ((bytesRead = this.inputStream.read(buf, cumulativeBytesRead, BUFFER_SIZE - cumulativeBytesRead)) == -1) {
                    this.closeFtpInputStream();
                    LOG.info((Object)"Data transfer completed.");
                    return this.writeBytesToSqoopRecord(buf, cumulativeBytesRead, (SqoopRecord)sqoopRecord);
                }
                if ((cumulativeBytesRead += bytesRead) != BUFFER_SIZE) continue;
                return this.writeBytesToSqoopRecord(buf, cumulativeBytesRead, (SqoopRecord)sqoopRecord);
            } while (bytesRead != -1);
        }
        catch (IOException ioe) {
            throw new IOException("IOException during data transfer: " + ioe);
        }
        return false;
    }

    protected Boolean initInputStream(int bufferSize) throws IOException {
        if (this.inputStream == null) {
            String dsName = this.getNextDataset();
            if (dsName == null) {
                LOG.info((Object)"No more datasets to process. Returning.");
                return false;
            }
            LOG.info((Object)("Attempting to retrieve file stream for: " + dsName));
            LOG.info((Object)("Buffer size: " + bufferSize));
            this.inputStream = new BufferedInputStream(this.ftp.retrieveFileStream(dsName));
            if (this.inputStream == null) {
                throw new IOException("Failed to retrieve FTP file stream.");
            }
        }
        return true;
    }

    protected void closeFtpInputStream() throws IOException {
        this.inputStream.close();
        this.inputStream = null;
        if (!this.ftp.completePendingCommand()) {
            throw new IOException("Failed to complete ftp command. FTP Response: " + this.ftp.getReplyString());
        }
    }

    protected Boolean writeBytesToSqoopRecord(byte[] buf, int cumulativeBytesRead, SqoopRecord sqoopRecord) {
        if (cumulativeBytesRead <= 0) {
            return false;
        }
        ByteBuffer buffer = ByteBuffer.allocate(cumulativeBytesRead);
        buffer.put(buf, 0, cumulativeBytesRead);
        this.convertToSqoopRecord(buffer.array(), sqoopRecord);
        return true;
    }

    private void convertToSqoopRecord(String line, SqoopRecord sqoopRecord) {
        String fieldName = sqoopRecord.getFieldMap().entrySet().iterator().next().getKey();
        sqoopRecord.setField(fieldName, line);
    }

    private void convertToSqoopRecord(byte[] buf, SqoopRecord sqoopRecord) {
        String fieldName = sqoopRecord.getFieldMap().entrySet().iterator().next().getKey();
        sqoopRecord.setField(fieldName, buf);
    }
}

