/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.AutoProgressMapper;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputSplit;

public abstract class AbstractMainframeDatasetImportMapper<KEY>
extends AutoProgressMapper<LongWritable, SqoopRecord, KEY, NullWritable> {
    private MainframeDatasetInputSplit inputSplit;
    private MultipleOutputs<KEY, NullWritable> multiFileWriter;
    private long numberOfRecords;

    public void map(LongWritable key, SqoopRecord val, Mapper.Context context) throws IOException, InterruptedException {
        String dataset = this.inputSplit.getCurrentDataset();
        ++this.numberOfRecords;
        this.multiFileWriter.write(this.createOutKey(val), (Object)NullWritable.get(), dataset);
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.inputSplit = (MainframeDatasetInputSplit)context.getInputSplit();
        this.multiFileWriter = new MultipleOutputs((TaskInputOutputContext)context);
        this.numberOfRecords = 0L;
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        this.multiFileWriter.close();
        context.getCounter("org.apache.hadoop.mapred.Task$Counter", "MAP_OUTPUT_RECORDS").increment(this.numberOfRecords);
    }

    protected abstract KEY createOutKey(SqoopRecord var1);
}

