/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.DBInputFormat;
import org.apache.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import org.apache.sqoop.mapreduce.db.SQLServerDBRecordReader;

public class SQLServerDBInputFormat<T extends SqoopRecord>
extends DataDrivenDBInputFormat<T>
implements Configurable {
    private static final Log LOG = LogFactory.getLog(SQLServerDBInputFormat.class);
    public static final String IMPORT_FAILURE_HANDLER_CLASS = "sqoop.import.failure.handler.class";

    @Override
    protected RecordReader<LongWritable, T> createDBRecordReader(DBInputFormat.DBInputSplit split, Configuration conf) throws IOException {
        DBConfiguration dbConf = this.getDBConf();
        Class<?> inputClass = dbConf.getInputClass();
        String dbProductName = this.getDBProductName();
        LOG.debug((Object)("Creating db record reader for db product: " + dbProductName));
        try {
            return new SQLServerDBRecordReader(split, inputClass, conf, this.getConnection(), dbConf, dbConf.getInputConditions(), dbConf.getInputFieldNames(), dbConf.getInputTableName(), dbProductName);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String conditions, String splitBy, String ... fieldNames) {
        DataDrivenDBInputFormat.setInput(job, inputClass, tableName, conditions, splitBy, fieldNames);
        job.setInputFormatClass(SQLServerDBInputFormat.class);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String inputQuery, String inputBoundingQuery) {
        DataDrivenDBInputFormat.setInput(job, inputClass, inputQuery, inputBoundingQuery);
        job.setInputFormatClass(SQLServerDBInputFormat.class);
    }
}

