/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.DBInputFormat;
import org.apache.sqoop.mapreduce.db.DBRecordReader;
import org.apache.sqoop.mapreduce.db.DataDrivenDBInputFormat;

public class DataDrivenDBRecordReader<T extends DBWritable>
extends DBRecordReader<T> {
    private static final Log LOG = LogFactory.getLog(DataDrivenDBRecordReader.class);
    private String dbProductName;

    public DataDrivenDBRecordReader(DBInputFormat.DBInputSplit split, Class<T> inputClass, Configuration conf, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table, String dbProduct) throws SQLException {
        super(split, inputClass, conf, conn, dbConfig, cond, fields, table);
        this.dbProductName = dbProduct;
    }

    @Override
    public float getProgress() throws IOException {
        return this.isDone() ? 1.0f : 0.0f;
    }

    @Override
    protected String getSelectQuery() {
        DataDrivenDBInputFormat.DataDrivenDBInputSplit dataSplit = (DataDrivenDBInputFormat.DataDrivenDBInputSplit)this.getSplit();
        return this.getSelectQuery(dataSplit.getLowerClause(), dataSplit.getUpperClause());
    }

    protected String getSelectQuery(String lowerClause, String upperClause) {
        StringBuilder query = new StringBuilder();
        DBConfiguration dbConf = this.getDBConf();
        String[] fieldNames = this.getFieldNames();
        String tableName = this.getTableName();
        String conditions = this.getConditions();
        StringBuilder conditionClauses = new StringBuilder();
        conditionClauses.append("( ").append(lowerClause);
        conditionClauses.append(" ) AND ( ").append(upperClause);
        conditionClauses.append(" )");
        if (dbConf.getInputQuery() == null) {
            query.append("SELECT ");
            for (int i = 0; i < fieldNames.length; ++i) {
                query.append(fieldNames[i]);
                if (i == fieldNames.length - 1) continue;
                query.append(", ");
            }
            query.append(" FROM ").append(tableName);
            if (!(this.dbProductName.startsWith("ORACLE") || this.dbProductName.startsWith("DB2") || this.dbProductName.startsWith("MICROSOFT SQL SERVER") || this.dbProductName.startsWith("POSTGRESQL"))) {
                query.append(" AS ").append(tableName);
            }
            query.append(" WHERE ");
            if (conditions != null && conditions.length() > 0) {
                query.append("( ").append(conditions).append(" ) AND ");
            }
            query.append(conditionClauses.toString());
        } else {
            String inputQuery = dbConf.getInputQuery();
            if (inputQuery.indexOf("$CONDITIONS") == -1) {
                LOG.error((Object)("Could not find the clause substitution token $CONDITIONS in the query: [" + inputQuery + "]. Parallel splits may not work correctly."));
            }
            query.append(inputQuery.replace("$CONDITIONS", conditionClauses.toString()));
        }
        LOG.debug((Object)("Using query: " + query.toString()));
        return query.toString();
    }
}

