/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.util.LoggingUtils;

public class DBOutputFormat<K extends DBWritable, V>
extends OutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(DBOutputFormat.class);

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new FileOutputCommitter(FileOutputFormat.getOutputPath((JobContext)context), context);
    }

    public String constructQuery(String table, String[] fieldNames) {
        int i;
        if (fieldNames == null) {
            throw new IllegalArgumentException("Field names may not be null");
        }
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ").append(table);
        if (fieldNames.length > 0 && fieldNames[0] != null) {
            query.append(" (");
            for (i = 0; i < fieldNames.length; ++i) {
                query.append(fieldNames[i]);
                if (i == fieldNames.length - 1) continue;
                query.append(",");
            }
            query.append(")");
        }
        query.append(" VALUES (");
        for (i = 0; i < fieldNames.length; ++i) {
            query.append("?");
            if (i == fieldNames.length - 1) continue;
            query.append(",");
        }
        query.append(");");
        return query.toString();
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        DBConfiguration dbConf = new DBConfiguration(context.getConfiguration());
        String tableName = dbConf.getOutputTableName();
        String[] fieldNames = dbConf.getOutputFieldNames();
        if (fieldNames == null) {
            fieldNames = new String[dbConf.getOutputFieldCount()];
        }
        try {
            Connection connection = dbConf.getConnection();
            PreparedStatement statement = null;
            statement = connection.prepareStatement(this.constructQuery(tableName, fieldNames));
            return new DBRecordWriter(connection, statement);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static void setOutput(Job job, String tableName, String ... fieldNames) throws IOException {
        if (fieldNames.length > 0 && fieldNames[0] != null) {
            DBConfiguration dbConf = DBOutputFormat.setOutput(job, tableName);
            dbConf.setOutputFieldNames(fieldNames);
        } else if (fieldNames.length > 0) {
            DBOutputFormat.setOutput(job, tableName, fieldNames.length);
        } else {
            throw new IllegalArgumentException("Field names must be greater than 0");
        }
    }

    public static void setOutput(Job job, String tableName, int fieldCount) throws IOException {
        DBConfiguration dbConf = DBOutputFormat.setOutput(job, tableName);
        dbConf.setOutputFieldCount(fieldCount);
    }

    private static DBConfiguration setOutput(Job job, String tableName) throws IOException {
        job.setOutputFormatClass(DBOutputFormat.class);
        ConfigurationHelper.setJobReduceSpeculativeExecution(job, false);
        DBConfiguration dbConf = new DBConfiguration(job.getConfiguration());
        dbConf.setOutputTableName(tableName);
        return dbConf;
    }

    public static class DBRecordWriter<K extends DBWritable, V>
    extends RecordWriter<K, V> {
        private Connection connection;
        private PreparedStatement statement;

        public DBRecordWriter() throws SQLException {
        }

        public DBRecordWriter(Connection connection, PreparedStatement statement) throws SQLException {
            this.connection = connection;
            this.statement = statement;
            this.connection.setAutoCommit(false);
        }

        public Connection getConnection() {
            return this.connection;
        }

        public PreparedStatement getStatement() {
            return this.statement;
        }

        public void close(TaskAttemptContext context) throws IOException {
            try {
                this.statement.executeBatch();
                this.connection.commit();
            }
            catch (SQLException e) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)StringUtils.stringifyException((Throwable)ex));
                }
                throw new IOException(e);
            }
            finally {
                try {
                    this.statement.close();
                    this.connection.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Unable to close connection", ex);
                }
            }
        }

        public void write(K key, V value) throws IOException {
            try {
                key.write(this.statement);
                this.statement.addBatch();
            }
            catch (SQLException e) {
                LoggingUtils.logAll(LOG, "Exception encountered", e);
            }
        }
    }
}

