/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.AutoProgressMapper;
import org.apache.sqoop.mapreduce.CombineFileSplit;

public class TextExportMapper
extends AutoProgressMapper<LongWritable, Text, SqoopRecord, NullWritable> {
    private static final String DUMP_DATA_ON_ERROR_KEY = "org.apache.sqoop.export.text.dump_data_on_error";
    public static final Log LOG = LogFactory.getLog((String)TextExportMapper.class.getName());
    private SqoopRecord recordImpl;
    boolean enableDataDumpOnError;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String recordClassName = conf.get("sqoop.mapreduce.export.table.class");
        if (null == recordClassName) {
            throw new IOException("Export table class name (sqoop.mapreduce.export.table.class) is not set!");
        }
        try {
            Class<?> cls = Class.forName(recordClassName, true, Thread.currentThread().getContextClassLoader());
            this.recordImpl = (SqoopRecord)ReflectionUtils.newInstance(cls, (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        if (null == this.recordImpl) {
            throw new IOException("Could not instantiate object of type " + recordClassName);
        }
        this.enableDataDumpOnError = conf.getBoolean(DUMP_DATA_ON_ERROR_KEY, false);
    }

    public void map(LongWritable key, Text val, Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.recordImpl.parse(val);
            context.write((Object)this.recordImpl, (Object)NullWritable.get());
        }
        catch (Exception e) {
            LOG.error((Object)"");
            LOG.error((Object)"Exception raised during data export");
            LOG.error((Object)"");
            LOG.error((Object)"Exception: ", (Throwable)e);
            if (this.enableDataDumpOnError) {
                LOG.error((Object)("On input: " + val));
            } else {
                LOG.error((Object)"Dumping data is not allowed by default, please run the job with -Dorg.apache.sqoop.export.text.dump_data_on_error=true to get corrupted line.");
            }
            InputSplit is = context.getInputSplit();
            if (is instanceof FileSplit) {
                LOG.error((Object)("On input file: " + ((FileSplit)is).getPath()));
            } else if (is instanceof CombineFileSplit) {
                LOG.error((Object)("On input file: " + context.getConfiguration().get("map.input.file")));
            }
            LOG.error((Object)("At position " + key));
            LOG.error((Object)"");
            LOG.error((Object)"Currently processing split:");
            LOG.error((Object)is);
            LOG.error((Object)"");
            LOG.error((Object)"This issue might not necessarily be caused by current input");
            LOG.error((Object)"due to the batching nature of export.");
            LOG.error((Object)"");
            throw new IOException("Can't export data, please check failed map task logs", e);
        }
    }
}

