/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.ImportJobBase;
import org.apache.sqoop.mapreduce.MySQLDumpInputFormat;
import org.apache.sqoop.mapreduce.MySQLDumpMapper;
import org.apache.sqoop.mapreduce.RawKeyTextOutputFormat;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.DataDrivenDBInputFormat;

public class MySQLDumpImportJob
extends ImportJobBase {
    public static final Log LOG = LogFactory.getLog((String)MySQLDumpImportJob.class.getName());

    public MySQLDumpImportJob(SqoopOptions opts, ImportJobContext context) throws ClassNotFoundException {
        super(opts, MySQLDumpMapper.class, MySQLDumpInputFormat.class, RawKeyTextOutputFormat.class, context);
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
        if (null == tableName) {
            LOG.error((Object)"mysqldump-based import cannot support free-form query imports.");
            LOG.error((Object)"Do not use --direct and --query together for MySQL.");
            throw new IOException("null tableName for MySQLDumpImportJob.");
        }
        ConnManager mgr = this.getContext().getConnManager();
        String username = this.options.getUsername();
        if (null == username || username.length() == 0) {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), this.options.getConnectionParams());
        } else {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword(), this.options.getConnectionParams());
        }
        String[] colNames = this.options.getColumns();
        if (null == colNames) {
            colNames = mgr.getColumnNames(tableName);
        }
        String[] sqlColNames = null;
        if (null != colNames) {
            sqlColNames = new String[colNames.length];
            for (int i = 0; i < colNames.length; ++i) {
                sqlColNames[i] = mgr.escapeColName(colNames[i]);
            }
        }
        String whereClause = this.options.getWhereClause();
        DataDrivenDBInputFormat.setInput(job, DBWritable.class, tableName, whereClause, mgr.escapeColName(splitByCol), sqlColNames);
        Configuration conf = job.getConfiguration();
        conf.setInt("sqoop.output.field.delim", (int)this.options.getOutputFieldDelim());
        conf.setInt("sqoop.output.record.delim", (int)this.options.getOutputRecordDelim());
        conf.setInt("sqoop.output.enclosed.by", (int)this.options.getOutputEnclosedBy());
        conf.setInt("sqoop.output.escaped.by", (int)this.options.getOutputEscapedBy());
        conf.setBoolean("sqoop.output.enclose.required", this.options.isOutputEncloseRequired());
        String[] extraArgs = this.options.getExtraArgs();
        if (null != extraArgs) {
            conf.setStrings("sqoop.mysql.extra.args", extraArgs);
        }
        LOG.debug((Object)("Using InputFormat: " + this.inputFormatClass));
        job.setInputFormatClass(this.getInputFormatClass());
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        job.setMapperClass(this.getMapperClass());
        job.setOutputKeyClass(String.class);
        job.setOutputValueClass(NullWritable.class);
    }
}

