/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.MergeRecord;

public abstract class MergeReducerBase<KEYOUT, VALUEOUT>
extends Reducer<Text, MergeRecord, KEYOUT, VALUEOUT> {
    public void reduce(Text key, Iterable<MergeRecord> vals, Reducer.Context c) throws IOException, InterruptedException {
        SqoopRecord bestRecord = null;
        try {
            for (MergeRecord val : vals) {
                if (null == bestRecord && !val.isNewRecord()) {
                    bestRecord = (SqoopRecord)val.getSqoopRecord().clone();
                    continue;
                }
                if (!val.isNewRecord()) continue;
                bestRecord = (SqoopRecord)val.getSqoopRecord().clone();
            }
        }
        catch (CloneNotSupportedException cnse) {
            throw new IOException(cnse);
        }
        if (null != bestRecord) {
            this.writeRecord(bestRecord, c);
        }
    }

    protected abstract void writeRecord(SqoopRecord var1, Reducer.Context var2) throws IOException, InterruptedException;
}

