/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.MergeRecord;

public class MergeMapperBase<INKEY, INVAL>
extends Mapper<INKEY, INVAL, Text, MergeRecord> {
    public static final Log LOG = LogFactory.getLog((String)MergeMapperBase.class.getName());
    private String keyColName;
    private boolean isNew;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.keyColName = conf.get("sqoop.merge.key.col");
        InputSplit is = context.getInputSplit();
        FileSplit fs = (FileSplit)is;
        Path splitPath = fs.getPath();
        if (splitPath.toString().startsWith(conf.get("sqoop.merge.new.path"))) {
            this.isNew = true;
        } else if (splitPath.toString().startsWith(conf.get("sqoop.merge.old.path"))) {
            this.isNew = false;
        } else {
            throw new IOException("File " + splitPath + " is not under new path " + conf.get("sqoop.merge.new.path") + " or old path " + conf.get("sqoop.merge.old.path"));
        }
    }

    protected void processRecord(SqoopRecord r, Mapper.Context c) throws IOException, InterruptedException {
        MergeRecord mr = new MergeRecord(r, this.isNew);
        Map<String, Object> fieldMap = r.getFieldMap();
        if (null == fieldMap) {
            throw new IOException("No field map in record " + r);
        }
        Object keyObj = fieldMap.get(this.keyColName);
        if (null == keyObj) {
            throw new IOException("Cannot join values on null key. Did you specify a key column that exists?");
        }
        c.write((Object)new Text(keyObj.toString()), (Object)mr);
    }
}

