/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.AvroJob;
import org.apache.sqoop.mapreduce.MergeReducerBase;

public class MergeAvroReducer
extends MergeReducerBase<AvroWrapper<GenericRecord>, NullWritable> {
    private AvroWrapper<GenericRecord> wrapper;
    private Schema schema;
    private boolean bigDecimalFormatString;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.wrapper = new AvroWrapper();
        this.schema = AvroJob.getOutputSchema(context.getConfiguration());
        this.bigDecimalFormatString = context.getConfiguration().getBoolean("sqoop.bigdecimal.format.string", true);
    }

    @Override
    protected void writeRecord(SqoopRecord record, Reducer.Context context) throws IOException, InterruptedException {
        GenericRecord outKey = AvroUtil.toGenericRecord(record.getFieldMap(), this.schema, this.bigDecimalFormatString);
        this.wrapper.datum((Object)outKey);
        context.write(this.wrapper, (Object)NullWritable.get());
    }
}

