/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class KeyRecordWriters {

    public static class BinaryKeyRecordWriter<K, V>
    extends GenericRecordWriter<K, V> {
        public BinaryKeyRecordWriter(DataOutputStream out) {
            this.out = out;
        }

        @Override
        protected void writeObject(Object o, Object value) throws IOException {
            if (o instanceof BytesWritable) {
                BytesWritable to = (BytesWritable)o;
                this.out.write(to.getBytes(), 0, to.getLength());
            }
        }
    }

    public static class RawKeyRecordWriter<K, V>
    extends GenericRecordWriter<K, V> {
        public RawKeyRecordWriter(DataOutputStream out) {
            this.out = out;
        }
    }

    public static class GenericRecordWriter<K, V>
    extends RecordWriter<K, V> {
        private static final String UTF8 = "UTF-8";
        protected DataOutputStream out;

        protected void writeObject(Object o, Object value) throws IOException {
            if (o instanceof Text) {
                Text to = (Text)o;
                this.out.write(to.getBytes(), 0, to.getLength());
            } else {
                this.out.write(o.toString().getBytes(UTF8));
            }
        }

        public synchronized void write(K key, V value) throws IOException, InterruptedException {
            this.writeObject(key, value);
        }

        public synchronized void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.out.close();
        }
    }
}

