/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.lib.FieldMapProcessor;
import org.apache.sqoop.lib.FieldMappable;
import org.apache.sqoop.lib.ProcessingException;
import org.apache.sqoop.mapreduce.NullOutputCommitter;

public class DelegatingOutputFormat<K extends FieldMappable, V>
extends OutputFormat<K, V> {
    public static final String DELEGATE_CLASS_KEY = "sqoop.output.delegate.field.map.processor.class";

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        if (null == conf.get(DELEGATE_CLASS_KEY)) {
            throw new IOException("Delegate FieldMapProcessor class is not set.");
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new DelegatingRecordWriter(context);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
    }

    public class DelegatingRecordWriter
    extends RecordWriter<K, V> {
        private Configuration conf;
        private FieldMapProcessor mapProcessor;

        public DelegatingRecordWriter(TaskAttemptContext context) throws ClassNotFoundException {
            this.conf = context.getConfiguration();
            Class procClass = this.conf.getClass(DelegatingOutputFormat.DELEGATE_CLASS_KEY, null);
            this.mapProcessor = (FieldMapProcessor)ReflectionUtils.newInstance((Class)procClass, (Configuration)this.conf);
        }

        protected Configuration getConf() {
            return this.conf;
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            if (this.mapProcessor instanceof Closeable) {
                ((Closeable)((Object)this.mapProcessor)).close();
            }
        }

        public void write(K key, V value) throws InterruptedException, IOException {
            try {
                this.mapProcessor.accept((FieldMappable)key);
            }
            catch (ProcessingException pe) {
                throw new IOException(pe);
            }
        }
    }
}

