/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import org.apache.avro.LogicalType;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.config.ConfigurationHelper;

public final class OracleUtils {
    private static final String PERIOD_REGEX = "\\.";
    private static final String PERIOD_DELIMITER = ".";
    private static final int SCALE_VALUE_NOT_SET = -127;

    public static boolean isOracleEscapingDisabled(Configuration conf) {
        return conf.getBoolean("sqoop.oracle.escaping.disabled", true);
    }

    public static boolean isEscaped(String identifier) {
        return !StringUtils.isBlank((CharSequence)identifier) && identifier.startsWith("\"") && identifier.endsWith("\"");
    }

    public static String escapeIdentifier(String identifier) {
        return OracleUtils.escapeIdentifier(identifier, false);
    }

    public static String escapeIdentifier(String identifier, boolean escapingDisabled) {
        if (escapingDisabled || StringUtils.isBlank((CharSequence)identifier)) {
            return identifier;
        }
        if (OracleUtils.isEscaped(identifier)) {
            return identifier;
        }
        String[] parts = identifier.split(PERIOD_REGEX);
        StringBuilder escapedIdentifier = new StringBuilder();
        for (String part : parts) {
            if (StringUtils.isNotBlank((CharSequence)escapedIdentifier)) {
                escapedIdentifier.append(PERIOD_DELIMITER);
            }
            escapedIdentifier.append("\"").append(part).append("\"");
        }
        return StringUtils.isNotBlank((CharSequence)escapedIdentifier) ? escapedIdentifier.toString() : null;
    }

    public static String unescapeIdentifier(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return identifier;
        }
        if (OracleUtils.isEscaped(identifier)) {
            return identifier.substring(1, identifier.length() - 1);
        }
        return identifier;
    }

    public static LogicalType toAvroLogicalType(int sqlType, Integer precision, Integer scale, Configuration conf) {
        switch (sqlType) {
            case 2: 
            case 3: {
                if (scale < 0 && OracleUtils.isValidScale(scale) && OracleUtils.isValidPrecision(precision)) {
                    precision = precision - scale;
                    scale = 0;
                }
                Integer configuredScale = ConfigurationHelper.getIntegerConfigIfExists(conf, "sqoop.avro.logical_types.decimal.default.scale");
                if (!OracleUtils.isValidScale(scale) && configuredScale == null) {
                    throw new RuntimeException("Invalid scale for Avro Schema. Please specify a default scale with the -Dsqoop.avro.logical_types.decimal.default.scale flag to avoid this issue.");
                }
                return AvroUtil.createDecimalType(precision, scale, conf);
            }
        }
        throw new IllegalArgumentException("Cannot convert SQL type " + sqlType + " to avro logical type");
    }

    public static boolean isValidScale(Integer scale) {
        return scale != -127;
    }

    public static boolean isValidPrecision(Integer precision) {
        return precision >= 1;
    }
}

