/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopOutputFormatBase;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.apache.sqoop.manager.oracle.OracleTable;
import org.apache.sqoop.manager.oracle.OracleUtils;

public class OraOopOutputFormatInsert<K extends SqoopRecord, V>
extends OraOopOutputFormatBase<K, V> {
    private static final OraOopLog LOG = OraOopLogFactory.getLog(OraOopOutputFormatInsert.class);

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        OraOopUtilities.checkJavaSecurityEgd();
        Configuration conf = context.getConfiguration();
        int mapperId = this.getMapperId(context);
        this.applyMapperJdbcUrl(context, mapperId);
        InsertMode insertMode = OraOopUtilities.getExportInsertMode(conf);
        boolean useAppendValuesOracleHint = false;
        if (insertMode == InsertMode.ExchangePartition) {
            useAppendValuesOracleHint = this.canUseOracleAppendValuesHint(context);
        }
        if (useAppendValuesOracleHint = this.allowUserToOverrideUseOfTheOracleAppendValuesHint(context, useAppendValuesOracleHint)) {
            this.updateBatchSizeInConfigurationToAllowOracleAppendValuesHint(context);
        }
        OraOopDBRecordWriterInsert result = null;
        try {
            result = new OraOopDBRecordWriterInsert(context, mapperId, insertMode, useAppendValuesOracleHint);
        }
        catch (NoClassDefFoundError ex) {
            throw new IOException(String.format("Unable to create an instance of OraOopDBRecordWriterInsert.\nThe classpath is:\n%s", OraOopUtilities.getJavaClassPath()), ex);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        try {
            result.getExportTableAndColumns(context);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        return result;
    }

    public class OraOopDBRecordWriterInsert
    extends OraOopOutputFormatBase.OraOopDBRecordWriterBase {
        private String sqlStatement;
        private InsertMode insertMode;
        private boolean useAppendValuesOracleHint;
        private String subPartitionName;

        public OraOopDBRecordWriterInsert(TaskAttemptContext context, int mapperId, InsertMode insertMode, boolean useAppendValuesOracleHint) throws ClassNotFoundException, SQLException {
            super(context, mapperId);
            this.insertMode = insertMode;
            this.useAppendValuesOracleHint = useAppendValuesOracleHint;
        }

        @Override
        protected void getExportTableAndColumns(TaskAttemptContext context) throws SQLException {
            Configuration conf = context.getConfiguration();
            switch (this.insertMode) {
                case DirectInsert: {
                    super.getExportTableAndColumns(context);
                    break;
                }
                case ExchangePartition: {
                    this.oracleTable = this.createUniqueMapperTable(context);
                    this.setOracleTableColumns(OraOopOracleQueries.getTableColumns(this.getConnection(), this.oracleTable, OraOopUtilities.omitLobAndLongColumnsDuringImport(conf), OraOopUtilities.recallSqoopJobType(conf), true, false, OracleUtils.isOracleEscapingDisabled(conf)));
                    this.subPartitionName = OraOopUtilities.generateExportTableSubPartitionName(this.mapperId, this.getJobSysDate(context), conf);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Update %s to cater for the insertMode \"%s\".", OraOopUtilities.getCurrentMethodName(), this.insertMode.toString()));
                }
            }
        }

        @Override
        public void closeConnection(TaskAttemptContext context) throws SQLException {
            if (this.insertMode == InsertMode.ExchangePartition) {
                this.exchangePartitionUniqueMapperTableDataIntoMainExportTable(context);
                LOG.debug(String.format("Dropping temporary mapper table %s", this.oracleTable.toString()));
                OraOopOracleQueries.dropTable(this.getConnection(), this.oracleTable);
            }
            super.closeConnection(context);
        }

        private void exchangePartitionUniqueMapperTableDataIntoMainExportTable(TaskAttemptContext context) throws SQLException {
            String schema = context.getConfiguration().get("oraoop.table.owner");
            String localTableName = context.getConfiguration().get("oraoop.table.name");
            OracleTable mainTable = new OracleTable(schema, localTableName);
            try {
                long start = System.nanoTime();
                OraOopOracleQueries.exchangeSubpartition(this.getConnection(), mainTable, this.subPartitionName, this.oracleTable);
                double timeInSec = (double)(System.nanoTime() - start) / Math.pow(10.0, 9.0);
                LOG.info(String.format("Time spent performing an \"exchange subpartition with table\": %f sec.", timeInSec));
            }
            catch (SQLException ex) {
                throw new SQLException(String.format("Unable to perform an \"exchange subpartition\" operation for the table %s, for the subpartition named \"%s\" with the table named \"%s\".", mainTable.toString(), this.subPartitionName, this.oracleTable.toString()), ex);
            }
        }

        @Override
        protected String getBatchSqlStatement() {
            if (this.sqlStatement == null) {
                this.sqlStatement = this.getBatchInsertSqlStatement(this.useAppendValuesOracleHint ? "/*+APPEND_VALUES*/" : "");
            }
            return this.sqlStatement;
        }

        @Override
        void configurePreparedStatement(PreparedStatement statement, List<SqoopRecord> userRecords) throws SQLException {
            try {
                for (SqoopRecord sqoopRecord : userRecords) {
                    int fieldCount = sqoopRecord.write(statement, 0);
                    if (this.tableHasMapperRowNumberColumn) {
                        statement.setLong(fieldCount + 1, this.mapperRowNumber);
                        ++this.mapperRowNumber;
                    }
                    statement.addBatch();
                }
            }
            catch (Exception ex) {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                LOG.error(String.format("The following error occurred during %s", OraOopUtilities.getCurrentMethodName()), ex);
                throw new SQLException(ex);
            }
        }
    }

    public static enum InsertMode {
        DirectInsert,
        ExchangePartition;

    }
}

