/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.sqoop.manager.oracle.OraOopOracleDataChunk;

public class OraOopOracleDataChunkPartition
extends OraOopOracleDataChunk {
    private boolean isSubPartition;
    private long blocks;

    OraOopOracleDataChunkPartition() {
    }

    OraOopOracleDataChunkPartition(String partitionName, boolean isSubPartition, long blocks) {
        this.setId(partitionName);
        this.isSubPartition = isSubPartition;
        this.blocks = blocks;
    }

    @Override
    public long getNumberOfBlocks() {
        return this.blocks;
    }

    public void write(DataOutput output) throws IOException {
        Text.writeString((DataOutput)output, (String)this.getId());
        output.writeBoolean(this.isSubPartition);
        output.writeLong(this.blocks);
    }

    public void readFields(DataInput input) throws IOException {
        this.setId(Text.readString((DataInput)input));
        this.isSubPartition = input.readBoolean();
        this.blocks = input.readLong();
    }

    @Override
    public String getPartitionClause() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        if (this.isSubPartition) {
            sb.append("SUBPARTITION");
        } else {
            sb.append("PARTITION");
        }
        sb.append("(\"").append(this.getId()).append("\")");
        return sb.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\n\t\t id = ").append(this.getId());
        result.append("\n\t\t isSubPartition = ").append(this.isSubPartition);
        result.append("\n\t\t blocks = ").append(this.blocks);
        return result.toString();
    }
}

