/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.sqoop.manager.oracle.OraOopOracleDataChunk;

public class OraOopOracleDataChunkExtent
extends OraOopOracleDataChunk {
    private int oracleDataObjectId;
    private int relativeDatafileNumber;
    private long startBlockNumber;
    private long finishBlockNumber;

    OraOopOracleDataChunkExtent() {
    }

    OraOopOracleDataChunkExtent(String id, int oracleDataObjectId, int relativeDatafileNumber, long startBlockNumber, long finishBlockNumber) {
        this.setId(id);
        this.oracleDataObjectId = oracleDataObjectId;
        this.relativeDatafileNumber = relativeDatafileNumber;
        this.startBlockNumber = startBlockNumber;
        this.finishBlockNumber = finishBlockNumber;
    }

    @Override
    public String getWhereClause() {
        return String.format("(rowid >= dbms_rowid.rowid_create(%d, %d, %d, %d, %d)", 1, this.oracleDataObjectId, this.relativeDatafileNumber, this.startBlockNumber, 0) + String.format(" AND rowid <= dbms_rowid.rowid_create(%d, %d, %d, %d, %d))", 1, this.oracleDataObjectId, this.relativeDatafileNumber, this.finishBlockNumber, Short.MAX_VALUE);
    }

    public void write(DataOutput output) throws IOException {
        Text.writeString((DataOutput)output, (String)this.getId());
        output.writeInt(this.oracleDataObjectId);
        output.writeInt(this.relativeDatafileNumber);
        output.writeLong(this.startBlockNumber);
        output.writeLong(this.finishBlockNumber);
    }

    public void readFields(DataInput input) throws IOException {
        this.setId(Text.readString((DataInput)input));
        this.oracleDataObjectId = input.readInt();
        this.relativeDatafileNumber = input.readInt();
        this.startBlockNumber = input.readLong();
        this.finishBlockNumber = input.readLong();
    }

    @Override
    public long getNumberOfBlocks() {
        if (this.finishBlockNumber == 0L && this.startBlockNumber == 0L) {
            return 0L;
        }
        return this.finishBlockNumber - this.startBlockNumber + 1L;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\n\t\t id = ").append(this.getId());
        result.append("\n\t\t oracleDataObjectId = ").append(this.oracleDataObjectId);
        result.append("\n\t\t relativeDatafileNumber = ").append(this.relativeDatafileNumber);
        result.append("\n\t\t startBlockNumber = ").append(this.startBlockNumber);
        result.append("\n\t\t finishBlockNumber = ").append(this.finishBlockNumber);
        return result.toString();
    }
}

