/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.manager.ExportJobContext;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.manager.InformationSchemaManager;
import org.apache.sqoop.manager.JdbcDrivers;
import org.apache.sqoop.manager.SqlServerManagerContextConfigurator;
import org.apache.sqoop.mapreduce.JdbcExportJob;
import org.apache.sqoop.mapreduce.JdbcUpdateExportJob;
import org.apache.sqoop.mapreduce.JdbcUpsertExportJob;
import org.apache.sqoop.mapreduce.sqlserver.SqlServerInputFormat;
import org.apache.sqoop.mapreduce.sqlserver.SqlServerUpsertOutputFormat;
import org.apache.sqoop.util.ExportException;
import org.apache.sqoop.util.ImportException;

public class SQLServerManager
extends InformationSchemaManager {
    public static final String SCHEMA = "schema";
    public static final String TABLE_HINTS = "table-hints";
    public static final String TABLE_HINTS_PROP = "org.apache.sqoop.manager.sqlserver.table.hints";
    public static final Log LOG = LogFactory.getLog((String)SQLServerManager.class.getName());
    public static final String IDENTITY_INSERT = "identity-insert";
    public static final String IDENTITY_INSERT_PROP = "org.apache.sqoop.manager.sqlserver.table.identity";
    private static final int DATETIMEOFFSET = -155;
    private String schema;
    private String tableHints;
    private boolean identityInserts;
    final SqlServerManagerContextConfigurator formatConfigurator;

    public SQLServerManager(SqoopOptions opts) {
        this(JdbcDrivers.SQLSERVER.getDriverClass(), opts);
    }

    public SQLServerManager(String driver, SqoopOptions opts) {
        this(driver, opts, new SqlServerManagerContextConfigurator());
    }

    public SQLServerManager(String driver, SqoopOptions opts, SqlServerManagerContextConfigurator configurator) {
        super(driver, opts);
        this.formatConfigurator = configurator;
        try {
            this.parseExtraArgs(opts.getExtraArgs());
        }
        catch (ParseException e) {
            throw new RuntimeException("Can't parse extra arguments", e);
        }
    }

    @Override
    public String toJavaType(int sqlType) {
        String javaType = sqlType == -155 ? "String" : super.toJavaType(sqlType);
        return javaType;
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        Configuration configuration = context.getOptions().getConf();
        if (this.tableHints != null) {
            configuration.set(TABLE_HINTS_PROP, this.tableHints);
        }
        String splitColumn = this.getSplitColumn(context.getOptions(), context.getTableName());
        context.setInputFormat(SqlServerInputFormat.class);
        this.formatConfigurator.configureContextForImport(context, splitColumn);
        super.importTable(context);
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        Configuration configuration = context.getOptions().getConf();
        if (this.tableHints != null) {
            configuration.set(TABLE_HINTS_PROP, this.tableHints);
        }
        configuration.setBoolean(IDENTITY_INSERT_PROP, this.identityInserts);
        this.formatConfigurator.configureContextForExport(context);
        JdbcExportJob exportJob = new JdbcExportJob(context, null, null, context.getOutputFormatClass(), this.getParquetJobConfigurator().createParquetExportJobConfigurator());
        exportJob.runExport();
    }

    @Override
    public void updateTable(ExportJobContext context) throws IOException, ExportException {
        boolean runAsExportJob = this.formatConfigurator.configureContextForUpdate(context, this);
        if (runAsExportJob) {
            JdbcUpdateExportJob exportJob = new JdbcUpdateExportJob(context, null, null, context.getOutputFormatClass(), this.getParquetJobConfigurator().createParquetExportJobConfigurator());
            exportJob.runExport();
        } else {
            super.updateTable(context);
        }
    }

    @Override
    public void upsertTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        Configuration configuration = context.getOptions().getConf();
        if (this.tableHints != null) {
            configuration.set(TABLE_HINTS_PROP, this.tableHints);
        }
        JdbcUpsertExportJob exportJob = new JdbcUpsertExportJob(context, SqlServerUpsertOutputFormat.class, this.getParquetJobConfigurator().createParquetExportJobConfigurator());
        exportJob.runExport();
    }

    @Override
    public void configureDbOutputColumns(SqoopOptions options) {
        if (options.getUpdateMode() == SqoopOptions.UpdateMode.UpdateOnly) {
            super.configureDbOutputColumns(options);
        } else {
            options.setDbOutputColumns(this.getColumnNames(options.getTableName()));
        }
    }

    @Override
    public String getCurTimestampQuery() {
        return "SELECT CURRENT_TIMESTAMP";
    }

    @Override
    protected String getListDatabasesQuery() {
        return "SELECT NAME FROM SYS.DATABASES";
    }

    @Override
    protected String getSchemaQuery() {
        if (this.schema == null) {
            return "SELECT SCHEMA_NAME()";
        }
        return "'" + this.schema + "'";
    }

    @Override
    protected String getListColumnsQuery(String tableName) {
        return "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = (" + this.getSchemaQuery() + ")   AND TABLE_NAME = N'" + tableName + "'   ORDER BY ORDINAL_POSITION";
    }

    @Override
    protected String getPrimaryKeyQuery(String tableName) {
        return "SELECT kcu.COLUMN_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc,   INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu WHERE tc.TABLE_SCHEMA = kcu.TABLE_SCHEMA   AND tc.TABLE_NAME = kcu.TABLE_NAME   AND tc.CONSTRAINT_SCHEMA = kcu.CONSTRAINT_SCHEMA   AND tc.CONSTRAINT_NAME = kcu.CONSTRAINT_NAME   AND tc.TABLE_SCHEMA = (" + this.getSchemaQuery() + ")   AND tc.TABLE_NAME = N'" + tableName + "'   AND tc.CONSTRAINT_TYPE = 'PRIMARY KEY'";
    }

    @Override
    public String escapeColName(String colName) {
        return this.escapeObjectName(colName);
    }

    @Override
    public String escapeTableName(String tableName) {
        if (this.schema != null && !this.schema.isEmpty()) {
            return this.escapeObjectName(this.schema) + "." + this.escapeObjectName(tableName);
        }
        return this.escapeObjectName(tableName);
    }

    @Override
    public boolean escapeTableNameOnExport() {
        return true;
    }

    public String escapeObjectName(String objectName) {
        if (null == objectName) {
            return null;
        }
        return "[" + objectName + "]";
    }

    void parseExtraArgs(String[] args) throws ParseException {
        if (args == null || args.length == 0) {
            return;
        }
        GnuParser parser = new GnuParser();
        CommandLine cmdLine = parser.parse((Options)this.getExtraOptions(), args, true);
        if (cmdLine.hasOption(SCHEMA)) {
            String schemaName = cmdLine.getOptionValue(SCHEMA);
            LOG.info((Object)("We will use schema " + schemaName));
            this.schema = schemaName;
        }
        if (cmdLine.hasOption(TABLE_HINTS)) {
            String hints = cmdLine.getOptionValue(TABLE_HINTS);
            LOG.info((Object)("Sqoop will use following table hints for data transfer: " + hints));
            this.tableHints = hints;
        }
        if (cmdLine.hasOption("resilient")) {
            LOG.warn((Object)"Sqoop will use resilient operations! In case of import, the split-by column also has to be specified, unique, and in ascending order.");
        }
        this.identityInserts = cmdLine.hasOption(IDENTITY_INSERT);
    }

    private RelatedOptions getExtraOptions() {
        RelatedOptions extraOptions = new RelatedOptions("SQL Server extra options:");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optional schema name");
        OptionBuilder.withLongOpt((String)SCHEMA);
        extraOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optional table hints to use");
        OptionBuilder.withLongOpt((String)TABLE_HINTS);
        extraOptions.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Allow identity inserts");
        OptionBuilder.withLongOpt((String)IDENTITY_INSERT);
        extraOptions.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"resilient");
        extraOptions.addOption(OptionBuilder.create());
        return extraOptions;
    }

    @Override
    public void importQuery(ImportJobContext context) throws IOException, ImportException {
        String splitColumn = this.getSplitColumn(context.getOptions(), context.getTableName());
        this.formatConfigurator.configureContextForImport(context, splitColumn);
        super.importQuery(context);
    }
}

