/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.manager.ExportJobContext;
import org.apache.sqoop.manager.GenericJdbcManager;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.manager.JdbcDrivers;
import org.apache.sqoop.mapreduce.netezza.NetezzaDataDrivenDBInputFormat;
import org.apache.sqoop.util.ExportException;
import org.apache.sqoop.util.ImportException;

public class NetezzaManager
extends GenericJdbcManager {
    public static final Log LOG = LogFactory.getLog((String)NetezzaManager.class.getName());
    protected static boolean directModeWarningPrinted = false;
    protected static boolean batchModeWarningPrinted = false;
    public static final String NETEZZA_DATASLICE_ALIGNED_ACCESS_OPT = "netezza.dataslice.aligned.access";
    public static final String NETEZZA_DATASLICE_ALIGNED_ACCESS_LONG_ARG = "partitioned-access";

    public NetezzaManager(SqoopOptions opts) {
        super(JdbcDrivers.NETEZZA.getDriverClass(), opts);
    }

    @Override
    public String escapeColName(String colName) {
        return this.escapeIdentifier(colName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return this.escapeIdentifier(tableName);
    }

    protected String escapeIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        return "\"" + identifier.replace("\"", "\"\"") + "\"";
    }

    @Override
    public void close() throws SQLException {
        if (this.hasOpenConnection()) {
            this.getConnection().rollback();
        }
        super.close();
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        if (!directModeWarningPrinted) {
            LOG.warn((Object)"It looks like you are importing from Netezza.");
            LOG.warn((Object)"This transfer can be faster! Use the --direct");
            LOG.warn((Object)"option to exercise a Netezza-specific fast path.");
            directModeWarningPrinted = true;
        }
        try {
            this.handleNetezzaImportExtraArgs(context);
        }
        catch (ParseException pe) {
            throw new ImportException(pe.getMessage(), pe);
        }
        super.importTable(context);
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        if (!directModeWarningPrinted) {
            LOG.warn((Object)"It looks like you are exporting to Netezza.");
            LOG.warn((Object)"This transfer can be faster! Use the --direct");
            LOG.warn((Object)"option to exercise a Netezza-specific fast path.");
            directModeWarningPrinted = true;
        }
        if (!this.options.isBatchMode()) {
            if (!batchModeWarningPrinted) {
                LOG.warn((Object)"It looks like you are exporting to Netezza in non-batch ");
                LOG.warn((Object)"mode.  Still this transfer can be made faster! Use the ");
                LOG.warn((Object)"--batch option to exercise a Netezza-specific fast path.");
                LOG.warn((Object)"Forcing records per statement to 1 in non batch mode");
                batchModeWarningPrinted = true;
            }
            context.getOptions().getConf().setInt("sqoop.export.records.per.statement", 1);
        }
        super.exportTable(context);
    }

    @Override
    public void updateTable(ExportJobContext context) throws IOException, ExportException {
        if (this.options.getNumMappers() > 1) {
            String msg = "Netezza update with multiple mappers can lead to inconsistencies - Please set num-mappers option to 1 in the SQOOP command line for update jobs with Netezza and SQOOP";
            throw new ExportException(msg);
        }
        if (!this.options.isBatchMode()) {
            if (!batchModeWarningPrinted) {
                LOG.warn((Object)"It looks like you are exporting to Netezza in non-batch ");
                LOG.warn((Object)"mode.  Still this transfer can be made faster! Use the ");
                LOG.warn((Object)"--batch option to exercise a Netezza-specific fast path.");
                LOG.warn((Object)"Forcing records per statement to 1 in non batch mode");
                batchModeWarningPrinted = true;
            }
            context.getOptions().getConf().setInt("sqoop.export.records.per.statement", 1);
        }
        super.updateTable(context);
    }

    @Override
    public boolean supportsStagingForExport() {
        return true;
    }

    @Override
    protected String getCurTimestampQuery() {
        return "SELECT CURRENT_TIMESTAMP";
    }

    protected RelatedOptions getNetezzaExtraOpts() {
        RelatedOptions netezzaOpts = new RelatedOptions("Netezza options");
        OptionBuilder.withArgName((String)NETEZZA_DATASLICE_ALIGNED_ACCESS_OPT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Data slice aligned import");
        OptionBuilder.withLongOpt((String)NETEZZA_DATASLICE_ALIGNED_ACCESS_LONG_ARG);
        netezzaOpts.addOption(OptionBuilder.create());
        return netezzaOpts;
    }

    private void handleNetezzaImportExtraArgs(ImportJobContext context) throws ParseException {
        RelatedOptions netezzaOpts;
        CommandLine cmdLine;
        SqoopOptions opts = context.getOptions();
        Configuration conf = opts.getConf();
        String[] extraArgs = opts.getExtraArgs();
        conf.setBoolean(NETEZZA_DATASLICE_ALIGNED_ACCESS_OPT, false);
        if (extraArgs != null && extraArgs.length > 0 && ConfigurationHelper.getConfNumMaps(conf) > 1 && (cmdLine = new GnuParser().parse((Options)(netezzaOpts = this.getNetezzaExtraOpts()), extraArgs, true)).hasOption(NETEZZA_DATASLICE_ALIGNED_ACCESS_LONG_ARG)) {
            conf.setBoolean(NETEZZA_DATASLICE_ALIGNED_ACCESS_OPT, true);
            context.setInputFormat(NetezzaDataDrivenDBInputFormat.class);
        }
    }
}

