/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.manager.ExportJobContext;
import org.apache.sqoop.manager.GenericJdbcManager;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.manager.JdbcDrivers;
import org.apache.sqoop.mapreduce.ExportBatchOutputFormat;
import org.apache.sqoop.mapreduce.JdbcExportJob;
import org.apache.sqoop.mapreduce.db.Db2DataDrivenDBInputFormat;
import org.apache.sqoop.util.ExportException;
import org.apache.sqoop.util.ImportException;
import org.apache.sqoop.util.LoggingUtils;

public class Db2Manager
extends GenericJdbcManager {
    public static final Log LOG = LogFactory.getLog((String)Db2Manager.class.getName());
    private static final String XML_TO_JAVA_DATA_TYPE = "String";
    private Map<String, String> columnTypeNames;
    public static final String SCHEMA = "schema";
    public static final String QUERY_LIST_SCHEMA_TABLES = "SELECT DISTINCT NAME FROM SYSIBM.SYSTABLES WHERE CREATOR =? AND TYPE='T' ";
    public static final String QUERY_GET_USERSCHEMA = "select current schema from sysibm.sysdummy1";
    private String schema = null;

    public Db2Manager(SqoopOptions opts) {
        super(JdbcDrivers.DB2.getDriverClass(), opts);
        try {
            this.schema = this.parseExtraScheArgs(opts.getExtraArgs(), this.getExtraOptions());
        }
        catch (ParseException e) {
            throw new RuntimeException("Can't parse extra arguments", e);
        }
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        context.setInputFormat(Db2DataDrivenDBInputFormat.class);
        super.importTable(context);
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        JdbcExportJob exportJob = new JdbcExportJob(context, null, null, ExportBatchOutputFormat.class, this.getParquetJobConfigurator().createParquetExportJobConfigurator());
        exportJob.runExport();
    }

    @Override
    public String getCurTimestampQuery() {
        return "SELECT CURRENT TIMESTAMP FROM SYSIBM.SYSDUMMY1 WITH UR";
    }

    @Override
    public String[] listDatabases() {
        Connection conn = null;
        ResultSet rset = null;
        ArrayList<String> databases = new ArrayList<String>();
        try {
            conn = this.getConnection();
            rset = conn.getMetaData().getSchemas();
            while (rset.next()) {
                databases.add(rset.getString(1));
            }
        }
        catch (SQLException sqle) {
            LoggingUtils.logAll(LOG, "Failed to list databases", sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException re) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", re);
                }
            }
        }
        return databases.toArray(new String[databases.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserSchema(Connection conn) {
        Statement stmt = null;
        ResultSet rset = null;
        String currSchema = null;
        try {
            stmt = conn.createStatement(1003, 1007);
            rset = stmt.executeQuery(QUERY_GET_USERSCHEMA);
            if (rset.next()) {
                currSchema = rset.getString(1);
            }
        }
        catch (SQLException e) {
            LoggingUtils.logAll(LOG, "Failed to get user schema", e);
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", ex);
                }
            }
        }
        if (currSchema == null) {
            throw new RuntimeException("Unable to get current user schema");
        }
        return currSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listTables() {
        Connection conn = null;
        Statement pStmt = null;
        ResultSet rset = null;
        ArrayList<String> tables = new ArrayList<String>();
        String currUserSchema = null;
        try {
            conn = this.getConnection();
            currUserSchema = Db2Manager.getUserSchema(conn);
            pStmt = conn.prepareStatement(QUERY_LIST_SCHEMA_TABLES, 1003, 1007);
            if (this.schema == null) {
                pStmt.setString(1, currUserSchema);
            } else {
                pStmt.setString(1, this.schema);
            }
            rset = pStmt.executeQuery();
            if (this.schema != null && rset == null) {
                LOG.debug((Object)("schema=" + this.schema + ",maybe not exists in current database"));
            }
            while (rset.next()) {
                if (this.schema == null) {
                    tables.add(rset.getString(1));
                    continue;
                }
                tables.add(this.schema + "." + rset.getString(1));
            }
        }
        catch (SQLException e) {
            LoggingUtils.logAll(LOG, "Failed to list tables", e);
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", ex);
                }
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", ex);
                }
            }
            try {
                this.close();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Unable to discard connection", ex);
            }
        }
        return tables.toArray(new String[tables.size()]);
    }

    @Override
    public String toHiveType(String tableName, String columnName, int sqlType) {
        String hiveType = super.toHiveType(tableName, columnName, sqlType);
        if (hiveType == null) {
            hiveType = this.toDbSpecificHiveType(tableName, columnName);
        }
        return hiveType;
    }

    private String toDbSpecificHiveType(String tableName, String colName) {
        if (this.columnTypeNames == null) {
            this.columnTypeNames = this.getColumnTypeNames(tableName, this.options.getCall(), this.options.getSqlQuery());
        }
        LOG.debug((Object)("database-specific Column Types and names returned = (" + StringUtils.join(this.columnTypeNames.keySet(), (String)",") + ")=>(" + StringUtils.join(this.columnTypeNames.values(), (String)",") + ")"));
        String colTypeName = this.columnTypeNames.get(colName);
        if (colTypeName != null && colTypeName.toUpperCase().startsWith("XML")) {
            return XML_TO_JAVA_DATA_TYPE;
        }
        return null;
    }

    @Override
    public String toJavaType(String tableName, String columnName, int sqlType) {
        String javaType = super.toJavaType(tableName, columnName, sqlType);
        if (javaType == null) {
            javaType = this.toDbSpecificJavaType(tableName, columnName);
        }
        return javaType;
    }

    private String toDbSpecificJavaType(String tableName, String colName) {
        String colTypeName;
        if (this.columnTypeNames == null) {
            this.columnTypeNames = this.getColumnTypeNames(tableName, this.options.getCall(), this.options.getSqlQuery());
        }
        if ((colTypeName = this.columnTypeNames.get(colName)) != null && colTypeName.equalsIgnoreCase("XML")) {
            return XML_TO_JAVA_DATA_TYPE;
        }
        return null;
    }

    protected RelatedOptions getExtraOptions() {
        RelatedOptions extraOptions = new RelatedOptions("DB2 extra options:");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optional schema name");
        OptionBuilder.withLongOpt((String)SCHEMA);
        extraOptions.addOption(OptionBuilder.create((String)SCHEMA));
        return extraOptions;
    }
}

