/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.lib;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.sqoop.io.LobFile;
import org.apache.sqoop.io.LobReaderCache;

public abstract class LobRef<DATATYPE, CONTAINERTYPE, ACCESSORTYPE>
implements Closeable,
Writable {
    public static final Log LOG = LogFactory.getLog((String)LobRef.class.getName());
    private CONTAINERTYPE realData;
    private String fileName;
    private long offset;
    private long length;
    private LobFile.Reader lobReader;
    protected static final ThreadLocal<Matcher> EXTERNAL_MATCHER = new ThreadLocal<Matcher>(){

        @Override
        protected Matcher initialValue() {
            Pattern externalPattern = Pattern.compile("externalLob\\(lf,(.*),([0-9]+),([0-9]+)\\)");
            return externalPattern.matcher("");
        }
    };

    protected LobRef() {
        this.fileName = null;
        this.offset = 0L;
        this.length = 0L;
        this.realData = null;
    }

    protected LobRef(CONTAINERTYPE container) {
        this.fileName = null;
        this.offset = 0L;
        this.length = 0L;
        this.realData = container;
    }

    protected LobRef(String file, long offset, long length) {
        this.fileName = file;
        this.offset = offset;
        this.length = length;
        this.realData = null;
    }

    protected CONTAINERTYPE getDataObj() {
        return this.realData;
    }

    protected void setDataObj(CONTAINERTYPE data) {
        this.realData = data;
    }

    public Object clone() throws CloneNotSupportedException {
        LobRef r = (LobRef)super.clone();
        r.lobReader = null;
        if (null != this.realData) {
            r.realData = this.deepCopyData(this.realData);
        }
        return r;
    }

    protected synchronized void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        if (null != this.lobReader) {
            LobReaderCache.getCache().recycle(this.lobReader);
        }
    }

    public boolean isExternal() {
        return this.fileName != null;
    }

    public ACCESSORTYPE getDataStream(Mapper.Context mapContext) throws IOException {
        InputSplit split = mapContext.getInputSplit();
        if (split instanceof FileSplit) {
            Path basePath = ((FileSplit)split).getPath().getParent();
            return this.getDataStream(mapContext.getConfiguration(), basePath);
        }
        throw new IllegalArgumentException("Could not ascertain LOB base path from MapContext.");
    }

    public ACCESSORTYPE getDataStream(Configuration conf, Path basePath) throws IOException {
        if (this.isExternal()) {
            Path pathToRead = LobReaderCache.qualify(new Path(basePath, this.fileName), conf);
            LOG.debug((Object)("Retreving data stream from external path: " + pathToRead));
            if (this.lobReader != null) {
                if (!pathToRead.equals((Object)this.lobReader.getPath())) {
                    LOG.debug((Object)("Releasing previous external reader for " + this.lobReader.getPath()));
                    LobReaderCache.getCache().recycle(this.lobReader);
                    this.lobReader = LobReaderCache.getCache().get(pathToRead, conf);
                }
            } else {
                this.lobReader = LobReaderCache.getCache().get(pathToRead, conf);
            }
            if (this.lobReader.tell() != this.offset) {
                LOG.debug((Object)("Seeking to record start offset " + this.offset));
                this.lobReader.seek(this.offset);
            }
            if (!this.lobReader.next()) {
                throw new IOException("Could not locate record at " + pathToRead + ":" + this.offset);
            }
            return this.getExternalSource(this.lobReader);
        }
        return this.getInternalSource(this.realData);
    }

    protected abstract ACCESSORTYPE getExternalSource(LobFile.Reader var1) throws IOException;

    protected abstract ACCESSORTYPE getInternalSource(CONTAINERTYPE var1);

    protected abstract DATATYPE getInternalData(CONTAINERTYPE var1);

    protected abstract CONTAINERTYPE deepCopyData(CONTAINERTYPE var1);

    public DATATYPE getData() {
        if (this.isExternal()) {
            throw new RuntimeException("External LOBs must be read via getDataStream()");
        }
        return this.getInternalData(this.realData);
    }

    public String toString() {
        if (this.isExternal()) {
            return "externalLob(lf," + this.fileName + "," + Long.toString(this.offset) + "," + Long.toString(this.length) + ")";
        }
        return this.realData.toString();
    }

    public void readFields(DataInput in) throws IOException {
        boolean isExternal = in.readBoolean();
        if (isExternal) {
            this.realData = null;
            String storageType = Text.readString((DataInput)in);
            if (!storageType.equals("lf")) {
                throw new IOException("Unsupported external LOB storage code: " + storageType);
            }
            this.fileName = Text.readString((DataInput)in);
            this.offset = in.readLong();
            this.length = in.readLong();
        } else {
            this.readFieldsInternal(in);
            this.fileName = null;
            this.offset = 0L;
            this.length = 0L;
        }
    }

    protected abstract void readFieldsInternal(DataInput var1) throws IOException;

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isExternal());
        if (this.isExternal()) {
            Text.writeString((DataOutput)out, (String)"lf");
            Text.writeString((DataOutput)out, (String)this.fileName);
            out.writeLong(this.offset);
            out.writeLong(this.length);
        } else {
            this.writeInternal(out);
        }
    }

    protected abstract void writeInternal(DataOutput var1) throws IOException;
}

