/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.lib;

import java.util.regex.Pattern;
import org.apache.sqoop.lib.DelimiterSet;

public final class FieldFormatter {
    private static final Pattern REPLACE_PATTERN = Pattern.compile("\\n|\\r|\u0001");

    public static String hiveStringDropDelims(String str, DelimiterSet delimiters) {
        return FieldFormatter.hiveStringReplaceDelims(str, "", delimiters);
    }

    public static String hiveStringReplaceDelims(String str, String replacement, DelimiterSet delimiters) {
        String droppedDelims = REPLACE_PATTERN.matcher(str).replaceAll(replacement);
        return FieldFormatter.escapeAndEnclose(droppedDelims, delimiters);
    }

    public static String escapeAndEnclose(String str, DelimiterSet delimiters) {
        boolean actuallyDoEnclose;
        boolean escapingLegal;
        char escape = delimiters.getEscapedBy();
        char enclose = delimiters.getEnclosedBy();
        boolean encloseRequired = delimiters.isEncloseRequired();
        boolean bl = escapingLegal = '\u0000' != escape;
        if (null == str) {
            return null;
        }
        String withEscapes = escapingLegal ? str.replace("" + escape, "" + escape + escape) : str;
        if ('\u0000' == enclose) {
            if (escapingLegal) {
                String fields = "" + delimiters.getFieldsTerminatedBy();
                String lines = "" + delimiters.getLinesTerminatedBy();
                withEscapes = withEscapes.replace(fields, "" + escape + fields);
                withEscapes = withEscapes.replace(lines, "" + escape + lines);
            }
            return withEscapes;
        }
        if (escapingLegal) {
            withEscapes = withEscapes.replace("" + enclose, "" + escape + enclose);
        }
        if (!(actuallyDoEnclose = encloseRequired)) {
            char[] mustEncloseFor = new char[]{delimiters.getFieldsTerminatedBy(), delimiters.getLinesTerminatedBy()};
            for (char reason : mustEncloseFor) {
                if (str.indexOf(reason) == -1) continue;
                actuallyDoEnclose = true;
                break;
            }
        }
        if (actuallyDoEnclose) {
            return "" + enclose + withEscapes + enclose;
        }
        return withEscapes;
    }

    private FieldFormatter() {
    }
}

