/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HiveTypes {
    private static final String HIVE_TYPE_TINYINT = "TINYINT";
    private static final String HIVE_TYPE_INT = "INT";
    private static final String HIVE_TYPE_BIGINT = "BIGINT";
    private static final String HIVE_TYPE_FLOAT = "FLOAT";
    private static final String HIVE_TYPE_DOUBLE = "DOUBLE";
    private static final String HIVE_TYPE_STRING = "STRING";
    private static final String HIVE_TYPE_BOOLEAN = "BOOLEAN";
    private static final String HIVE_TYPE_BINARY = "BINARY";
    public static final Log LOG = LogFactory.getLog((String)HiveTypes.class.getName());

    private HiveTypes() {
    }

    public static String toHiveType(int sqlType) {
        switch (sqlType) {
            case 4: 
            case 5: {
                return HIVE_TYPE_INT;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2005: {
                return HIVE_TYPE_STRING;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return HIVE_TYPE_DOUBLE;
            }
            case -7: 
            case 16: {
                return HIVE_TYPE_BOOLEAN;
            }
            case -6: {
                return HIVE_TYPE_TINYINT;
            }
            case -5: {
                return HIVE_TYPE_BIGINT;
            }
        }
        return null;
    }

    public static String toHiveType(Schema.Type avroType) {
        switch (avroType) {
            case BOOLEAN: {
                return HIVE_TYPE_BOOLEAN;
            }
            case INT: {
                return HIVE_TYPE_INT;
            }
            case LONG: {
                return HIVE_TYPE_BIGINT;
            }
            case FLOAT: {
                return HIVE_TYPE_FLOAT;
            }
            case DOUBLE: {
                return HIVE_TYPE_DOUBLE;
            }
            case STRING: 
            case ENUM: {
                return HIVE_TYPE_STRING;
            }
            case BYTES: 
            case FIXED: {
                return HIVE_TYPE_BINARY;
            }
        }
        return null;
    }

    public static boolean isHiveTypeImprovised(int sqlType) {
        return sqlType == 91 || sqlType == 92 || sqlType == 93 || sqlType == 3 || sqlType == 2;
    }
}

