/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.db.JdbcConnectionFactory;
import org.apache.sqoop.hive.HiveClient;
import org.apache.sqoop.hive.HiveClientCommon;
import org.apache.sqoop.hive.TableDefWriter;

public class HiveServer2Client
implements HiveClient {
    private static final Log LOG = LogFactory.getLog((String)HiveServer2Client.class.getName());
    private final SqoopOptions sqoopOptions;
    private final TableDefWriter tableDefWriter;
    private final JdbcConnectionFactory hs2ConnectionFactory;
    private final HiveClientCommon hiveClientCommon;

    public HiveServer2Client(SqoopOptions sqoopOptions, TableDefWriter tableDefWriter, JdbcConnectionFactory hs2ConnectionFactory, HiveClientCommon hiveClientCommon) {
        this.sqoopOptions = sqoopOptions;
        this.tableDefWriter = tableDefWriter;
        this.hs2ConnectionFactory = hs2ConnectionFactory;
        this.hiveClientCommon = hiveClientCommon;
    }

    public HiveServer2Client(SqoopOptions sqoopOptions, TableDefWriter tableDefWriter, JdbcConnectionFactory hs2ConnectionFactory) {
        this(sqoopOptions, tableDefWriter, hs2ConnectionFactory, new HiveClientCommon());
    }

    @Override
    public void importTable() throws IOException {
        LOG.info((Object)"Loading uploaded data into Hive.");
        String createTableStmt = this.tableDefWriter.getCreateTableStmt();
        String loadDataStmt = this.tableDefWriter.getLoadDataStmt();
        this.executeHiveImport(Arrays.asList(createTableStmt, loadDataStmt));
        LOG.info((Object)"Hive import complete.");
    }

    @Override
    public void createTable() throws IOException {
        LOG.info((Object)("Creating Hive table: " + this.tableDefWriter.getOutputTableName()));
        String createTableStmt = this.tableDefWriter.getCreateTableStmt();
        this.executeHiveImport(Arrays.asList(createTableStmt));
        LOG.info((Object)"Hive table is successfully created.");
    }

    void executeHiveImport(List<String> commands) throws IOException {
        Path finalPath = this.tableDefWriter.getFinalPath();
        this.hiveClientCommon.removeTempLogs(this.sqoopOptions.getConf(), finalPath);
        this.hiveClientCommon.indexLzoFiles(this.sqoopOptions, finalPath);
        try {
            this.executeCommands(commands);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing Hive import.", e);
        }
        this.hiveClientCommon.cleanUp(this.sqoopOptions.getConf(), finalPath);
    }

    void executeCommands(List<String> commands) throws SQLException {
        try (Connection hs2Connection = this.hs2ConnectionFactory.createConnection();){
            for (String command : commands) {
                LOG.debug((Object)("Executing command: " + command));
                PreparedStatement statement = hs2Connection.prepareStatement(command);
                Throwable throwable = null;
                try {
                    statement.execute();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
    }

    SqoopOptions getSqoopOptions() {
        return this.sqoopOptions;
    }

    TableDefWriter getTableDefWriter() {
        return this.tableDefWriter;
    }

    JdbcConnectionFactory getHs2ConnectionFactory() {
        return this.hs2ConnectionFactory;
    }
}

