/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Policy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.hive.HiveClient;
import org.apache.sqoop.hive.HiveClientCommon;
import org.apache.sqoop.hive.HiveConfig;
import org.apache.sqoop.hive.TableDefWriter;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.mapreduce.hcat.DerbyPolicy;
import org.apache.sqoop.util.Executor;
import org.apache.sqoop.util.ExitSecurityException;
import org.apache.sqoop.util.LoggingAsyncSink;
import org.apache.sqoop.util.SubprocessSecurityManager;

public class HiveImport
implements HiveClient {
    public static final Log LOG = LogFactory.getLog((String)HiveImport.class.getName());
    private SqoopOptions options;
    private ConnManager connManager;
    private Configuration configuration;
    private boolean generateOnly;
    private HiveClientCommon hiveClientCommon;
    private String previousLog4j2DisableJmxValue;
    private static boolean testMode = false;
    private static final String HIVE_MAIN_CLASS = "org.apache.hadoop.hive.cli.CliDriver";
    private static final String LOG4J2_DISABLE_JMX_KEY = "log4j2.disable.jmx";

    public static boolean getTestMode() {
        return testMode;
    }

    public static void setTestMode(boolean mode) {
        testMode = mode;
    }

    public HiveImport(SqoopOptions opts, ConnManager connMgr, Configuration conf, boolean generateOnly, HiveClientCommon hiveClientCommon) {
        this.options = opts;
        this.connManager = connMgr;
        this.configuration = conf;
        this.generateOnly = generateOnly;
        this.hiveClientCommon = hiveClientCommon;
    }

    public HiveImport(SqoopOptions opts, ConnManager connMgr, Configuration conf, boolean generateOnly) {
        this(opts, connMgr, conf, generateOnly, new HiveClientCommon());
    }

    private String getHiveBinPath() {
        String hiveCommand;
        String hiveHome = this.options.getHiveHome();
        String string = hiveCommand = Shell.WINDOWS ? "hive.cmd" : "hive";
        if (null == hiveHome) {
            return hiveCommand;
        }
        Path p = new Path(hiveHome);
        p = new Path(p, "bin");
        String hiveBinStr = (p = new Path(p, hiveCommand)).toString();
        if (new File(hiveBinStr).exists()) {
            return hiveBinStr;
        }
        return hiveCommand;
    }

    boolean isGenerateOnly() {
        return this.generateOnly;
    }

    private File getScriptFile(String outputTableName) throws IOException {
        if (!this.isGenerateOnly()) {
            return File.createTempFile("hive-script-", ".txt", new File(this.options.getTempDir()));
        }
        return new File(new File(this.options.getCodeOutputDir()), outputTableName + ".q");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTable(String inputTableName, String outputTableName, boolean createOnly) throws IOException {
        boolean debugMode;
        if (null == outputTableName) {
            outputTableName = inputTableName;
        }
        LOG.debug((Object)("Hive.inputTable: " + inputTableName));
        LOG.debug((Object)("Hive.outputTable: " + outputTableName));
        String expectedScript = System.getProperty("expected.script");
        List<String> env = Executor.getCurEnvpStrings();
        boolean bl = debugMode = expectedScript != null;
        if (debugMode) {
            env.add("EXPECTED_SCRIPT=" + expectedScript);
            String tmpDir = StringUtils.defaultString((String)this.options.getWarehouseDir(), (String)"/tmp");
            env.add("TMPDIR=" + tmpDir);
        }
        TableDefWriter tableWriter = new TableDefWriter(this.options, this.connManager, inputTableName, outputTableName, this.configuration, !debugMode);
        String createTableStr = tableWriter.getCreateTableStmt() + ";\n";
        String loadDataStmtStr = tableWriter.getLoadDataStmt() + ";\n";
        Path finalPath = tableWriter.getFinalPath();
        if (!this.isGenerateOnly()) {
            this.hiveClientCommon.removeTempLogs(this.configuration, finalPath);
            LOG.info((Object)"Loading uploaded data into Hive");
            this.hiveClientCommon.indexLzoFiles(this.options, finalPath);
        }
        File scriptFile = this.getScriptFile(outputTableName);
        try {
            String filename = scriptFile.toString();
            BufferedWriter w = null;
            try {
                FileOutputStream fos = new FileOutputStream(scriptFile);
                w = new BufferedWriter(new OutputStreamWriter(fos));
                w.write(createTableStr, 0, createTableStr.length());
                if (!createOnly) {
                    w.write(loadDataStmtStr, 0, loadDataStmtStr.length());
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)("Error writing Hive load-in script: " + ioe.toString()));
                ioe.printStackTrace();
                throw ioe;
            }
            finally {
                if (null != w) {
                    try {
                        w.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("IOException closing stream to Hive script: " + ioe.toString()));
                    }
                }
            }
            if (!this.isGenerateOnly()) {
                this.executeScript(filename, env);
                LOG.info((Object)"Hive import complete.");
                this.hiveClientCommon.cleanUp(this.configuration, finalPath);
            }
        }
        finally {
            if (!this.isGenerateOnly() && !scriptFile.delete()) {
                LOG.warn((Object)("Could not remove temporary file: " + scriptFile.toString()));
                scriptFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String filename, List<String> env) throws IOException {
        block13: {
            SubprocessSecurityManager subprocessSM = null;
            Policy originalPolicy = Policy.getPolicy();
            if (testMode) {
                LOG.debug((Object)"Using external Hive process in test mode.");
                this.executeExternalHiveScript(filename, env);
                return;
            }
            try {
                this.setSystemProperties();
                Class<?> cliDriverClass = Class.forName(HIVE_MAIN_CLASS);
                LOG.debug((Object)"Using in-process Hive instance.");
                subprocessSM = new SubprocessSecurityManager();
                subprocessSM.install();
                Policy.setPolicy(new DerbyPolicy());
                String[] argv = this.getHiveArgs("-f", filename);
                Method mainMethod = cliDriverClass.getMethod("main", String[].class);
                mainMethod.invoke(null, new Object[]{argv});
            }
            catch (ClassNotFoundException cnfe) {
                LOG.debug((Object)"Using external Hive process.");
                this.executeExternalHiveScript(filename, env);
            }
            catch (NoSuchMethodException nsme) {
                throw new IOException("Could not access CliDriver.main()", nsme);
            }
            catch (IllegalAccessException iae) {
                throw new IOException("Could not access CliDriver.main()", iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof ExitSecurityException) {
                    ExitSecurityException ese = (ExitSecurityException)cause;
                    int status = ese.getExitStatus();
                    if (status != 0) {
                        throw new IOException("Hive CliDriver exited with status=" + status);
                    }
                    break block13;
                }
                throw new IOException("Exception thrown in Hive", ite);
            }
            finally {
                if (null != subprocessSM) {
                    subprocessSM.uninstall();
                    Policy.setPolicy(originalPolicy);
                }
                this.resetSystemProperties();
            }
        }
    }

    private void setSystemProperties() {
        this.previousLog4j2DisableJmxValue = System.setProperty(LOG4J2_DISABLE_JMX_KEY, "true");
    }

    private void resetSystemProperties() {
        this.resetSystemProperty(LOG4J2_DISABLE_JMX_KEY, this.previousLog4j2DisableJmxValue);
    }

    private void resetSystemProperty(String key, String value) {
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    private void executeExternalHiveScript(String filename, List<String> env) throws IOException {
        String hiveExec = this.getHiveBinPath();
        String[] argv = this.getHiveArgs(hiveExec, "-f", filename);
        LoggingAsyncSink logSink = new LoggingAsyncSink(LOG);
        int ret = Executor.exec(argv, env.toArray(new String[0]), logSink, logSink);
        if (0 != ret) {
            throw new IOException("Hive exited with status " + ret);
        }
    }

    private String[] getHiveArgs(String ... args) throws IOException {
        LinkedList<String> newArgs = new LinkedList<String>();
        newArgs.addAll(Arrays.asList(args));
        HiveConfig.addHiveConfigs(HiveConfig.getHiveConf(this.configuration), this.configuration);
        if (this.configuration.getBoolean("hive.metastore.sasl.enabled", false)) {
            newArgs.add("--hiveconf");
            newArgs.add("hive.metastore.sasl.enabled=true");
        }
        return newArgs.toArray(new String[newArgs.size()]);
    }

    @Override
    public void importTable() throws IOException {
        this.importTable(this.options.getTableName(), this.options.getHiveTableName(), false);
    }

    @Override
    public void createTable() throws IOException {
        this.importTable(this.options.getTableName(), this.options.getHiveTableName(), true);
    }

    SqoopOptions getOptions() {
        return this.options;
    }

    ConnManager getConnManager() {
        return this.connManager;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }
}

