/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.sqoop.db.JdbcConnectionFactory;

public class DriverManagerJdbcConnectionFactory
implements JdbcConnectionFactory {
    private final String driverClass;
    private final String connectionString;
    private final String username;
    private final String password;
    private final Properties additionalProps;

    public DriverManagerJdbcConnectionFactory(String driverClass, String connectionString, String username, String password, Properties additionalProps) {
        this.driverClass = driverClass;
        this.connectionString = connectionString;
        this.username = username;
        this.password = password;
        this.additionalProps = additionalProps;
    }

    public DriverManagerJdbcConnectionFactory(String driverClass, String connectionString, String username, String password) {
        this(driverClass, connectionString, username, password, new Properties());
    }

    @Override
    public Connection createConnection() {
        this.loadDriverClass();
        Properties connectionProperties = new Properties();
        if (this.username != null) {
            connectionProperties.put("user", this.username);
        }
        if (this.password != null) {
            connectionProperties.put("password", this.password);
        }
        connectionProperties.putAll((Map<?, ?>)this.additionalProps);
        try {
            return DriverManager.getConnection(this.connectionString, connectionProperties);
        }
        catch (SQLException e) {
            throw new RuntimeException("Establishing connection failed!", e);
        }
    }

    private void loadDriverClass() {
        try {
            Class.forName(this.driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load db driver class: " + this.driverClass);
        }
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Properties getAdditionalProps() {
        return new Properties(this.additionalProps);
    }
}

